<?php

/*
 * This file is part of the Sonata project.
 *
 * (c) Thomas Rabaix <thomas.rabaix@sonata-project.org>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Sonata\NotificationBundle\Entity;

use Sonata\NotificationBundle\Model\Message;

class BaseMessage extends Message
{
    /**
     * @var int
     */
    protected $id;

    /**
     * Get id.
     *
     * @return int $id
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Override clone in order to avoid duplicating entries in Doctrine.
     */
    public function __clone()
    {
        parent::__clone();

        $this->id = null;
    }
}
