<?php

namespace sws\Bundle\FrontBundle\Services;
use Doctrine\ORM\EntityManager;

/**
 * Class RencontresDivision
 * @package sws\Bundle\FrontBundle\Services
 */
class RencontresDivision
{

    /**
     * @var
     */
    private $em;
    private $repository;
    private $rencontres;


    public function __construct(EntityManager $em){

        $this->em = $em;
        $this->repository = $em->getRepository('swsBackBundle:ChPlanning');
    }

    public function getRencontres()
    {
        return $this->rencontres;
    }


    /**
     * @param $division
     * @param $status
     *      - '-' : rencontres non attribuées (championnat non confirmé -> non utilisé en front office
     *      - 'O' : rencontres jouées
     *      - 'N' : rencontres non jouées
     * @param $limit : Nombre de row à retourner
     *
     */
    public function process($division, $status, $order, $limit)
    {

        if ($limit > 0){
            $this->rencontres = $this->repository->findBy(
                array(
                    'chdivision_id' => $division,
                    'status' => $status
                ),
                array(
                    'dateRencontre' => $order
                ),
                $limit
            );
        }
        else{
            $this->rencontres = $this->repository->findBy(
                array(
                    'chdivision_id' => $division,
                    'status' => $status
                ),
                array(
                    'dateRencontre' => $order
                )
            );
        }

    }

}