<?php

namespace sws\Bundle\FrontBundle\Services;
use Doctrine\ORM\EntityManager;

/**
 * Class RencontresChampionnatFront
 * @package sws\Bundle\FrontBundle\Services
 */
class RencontresChampionnatFront
{

    /**
     * @var
     */
    private $em;
    private $repository;
    private $rencontres;


    public function __construct(EntityManager $em){

        $this->em = $em;
        $this->repository = $em->getRepository('swsBackBundle:ChPlanning');
    }

    public function getRencontres()
    {
        return $this->rencontres;
    }


    /**
     * @param $championnat
     * @param $status
     *      - '-' : rencontres non attribuées (championnat non confirmé -> non utilisé en front office
     *      - 'O' : rencontres jouées
     *      - 'N' : rencontres non jouées
     * @param $limit : Nombre de row à retourner
     *
     */
    public function process($championnat, $status, $order, $limit)
    {

        $this->rencontres = $this->repository->findBy(
            array(
                'championnat_id' => $championnat,
                'status' => $status
            ),
            array(
                'dateRencontre' => $order
            ),
            $limit
        );
    }

}