<?php

namespace sws\Bundle\FrontBundle\Controller;

use sws\Bundle\FrontBundle\Entity\Post;
use sws\Bundle\BackBundle\Entity\ChPlanning;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

class RencontreController extends Controller
{
    public function indexAction(ChPlanning $idChPlanning)
    {
        // Récupération du championnat correspondant
        $Championnat_actif = $idChPlanning->getChampionnatId();

        // On recupere les divisions associées au championnat (pour menu)
        $ChDivisions = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChDivision')
            ->getChDivision($Championnat_actif);

        // On recuperre les rencontre jouées de la corporation
        /*
        $resultats = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontresCorporation($idChCorporation,'J');
        */

        // Recuperation des simples
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSimples');
        $rencontreSimple = $repository->findBy(array('chplanning_id' => $idChPlanning));

        // Recuperation des doubles
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDoubles');
        $rencontreDouble = $repository->findBy(array('chplanning_id' => $idChPlanning));

        // Recuperation les points des joueurs pour les simples
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChjoueurPtsSimple');
        $pointsJoueursSimple = $repository->findBy(array('chplanning_id' => $idChPlanning));

        // Recuperation les points des joueurs pour les doubles
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChjoueurPtsDouble');
        $pointsJoueursDouble = $repository->findBy(array('chplanning_id' => $idChPlanning));

        // On recupere les dernières news
         $lastNews = $this->get('app_repository_article')->getActiveArticles(5); 

        return $this->render('swsFrontBundle:Rencontre:rencontre.html.twig',array(
                'idChPlanning' => $idChPlanning,
                'ChDivisions' => $ChDivisions,
                'Championnat_actif' => $Championnat_actif,
                'lastNews' => $lastNews,
                'rencontreSimple' => $rencontreSimple,
                'rencontreDouble' => $rencontreDouble,
                'pointsJoueursSimple' => $pointsJoueursSimple,
                'pointsJoueursDouble' => $pointsJoueursDouble
            )
        );
    }

}
