<?php

namespace sws\Bundle\FrontBundle\Controller;

use Doctrine\ORM\EntityNotFoundException;
use sws\Bundle\FrontBundle\Entity\Joueurs;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;

class JoueursController extends Controller
{
    public function showAction($id)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsFrontBundle:Joueurs');
        $joueur = $repository->find($id);

        if (!$joueur) {
            throw new EntityNotFoundException();
        }

        return $this->render('swsFrontBundle:Joueurs:show.html.twig', array('joueur' => $joueur));
    }

    public function createAction(Request $request)
    {
 
         $form = $this->createFormBuilder(new Joueurs())
            ->add('nom')
            ->add('prenom')
            ->add('rue')
            ->add('numRue')
            ->add('boiteNumero',null, array('required' => false))
            ->add('codePostal')
            ->add('commune')
            ->add('telPrive',null, array('required' => false))
            ->add('gsmPrive',null, array('required' => false))
            ->add('faxPrive',null, array('required' => false))
            ->add('emailPrive',null, array('required' => false))
            ->add('telPro',null, array('required' => false))
            ->add('gsmPro',null, array('required' => false))
            ->add('faxPro',null, array('required' => false))
            ->add('emailPro',null, array('required' => false))
            ->add('dateNaissance','date',array('widget' => 'single_text','format' => 'dd-MM-yyyy','required' => false))
            ->add('numAft',null, array('required' => false))
            ->add('numClubAft',null, array('required' => false))
            ->add('numRil',null, array('required' => false))
            ->add('status','checkbox', array('required' => false))
            ->add('ghost','checkbox', array('required' => false))
            ->add('createdAt',null,array('attr'=>array('style'=>'display:none;')))
            ->add('updatedAt',null,array('attr'=>array('style'=>'display:none;')))
            ->add('submit','submit')
            ->getForm();

        $form->handleRequest($request);

        if ($request->ismethod('post') && $form->isValid())
        {
            $em = $this->getDoctrine()->getEntityManager();
            $em->persist($form->getData());
            $em->flush();

            return $this->redirect($this->generateUrl('sws_front_listjoueur'));
        }

        return $this->render('swsFrontBundle:joueurs:create.html.twig',array('form' => $form->createView()));
    }

    public function listAction()
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsFrontBundle:Joueurs');
        $joueurs = $repository->getAll();

        return $this->render('swsFrontBundle:Joueurs:list.html.twig', array('joueurs' => $joueurs));
    }
}

