<?php

namespace sws\Bundle\FrontBundle\Controller;

use sws\Bundle\FrontBundle\Entity\Post;
use sws\Bundle\BackBundle\Entity\ChJoueur;
use sws\Bundle\BackBundle\Entity\ChSimples;
use sws\Bundle\BackBundle\Entity\ChDoubles;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

class JoueurController extends Controller
{
    public function indexAction(ChJoueur $idChJoueur)
    {
        // Récupération du championnat correspondant à la corporation CH
        $Championnat_actif = $idChJoueur->getChampionnatId();

        // On recupere les divisions associées au championnat (pour menu)
        $ChDivisions = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChDivision')
            ->getChDivision($Championnat_actif);

        // On recuperre les rencontre jouées de la corporation
        /*
        $resultats = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontresCorporation($idChCorporation,'J');
        */

        // On récupère les joueurs de la corporations
        $joueursCorpoo = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:Chjoueur')
            ->getListeForceCorpo($idChJoueur->getChcorporationId());

        // On récupère les contacts de la corporations
        $pointsJoueur = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:Championnat')
            ->getPointsJoueur($idChJoueur);

        // On récupère les simples du joueur
        $joueursSimples = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChSimples')
            ->getSimplesCh($idChJoueur);
            
        // On récupère les doubles du joueur
        $joueursDoubles = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChDoubles')
            ->getDoublesCh($idChJoueur); 
         
        /*
        // On recupere le top 10 joueurs de la division
        $joueurTop10 = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:Championnat')
            ->getTopJoueurDivision($idChDivision,10);
        */

        // Récupération des 3 dernières news

       /* $listLast3Posts = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsFrontBundle:Post')
            ->getPosts(3);

       */

        return $this->render('swsFrontBundle:Joueur:joueur.html.twig',array(
                'idChJoueur' => $idChJoueur,
                'ChDivisions' => $ChDivisions,
                'Championnat_actif' => $Championnat_actif,
                'joueursCorpoo' => $joueursCorpoo,
                'pointsJoueur' => $pointsJoueur,
                'joueursSimples' => $joueursSimples,
                'joueursDoubles' => $joueursDoubles 
                //'listLast3Posts' =>$listLast3Posts
            )
        );
    }

}
