<?php

namespace sws\Bundle\FrontBundle\Controller;

use sws\Bundle\FrontBundle\Entity\Post;
use sws\Bundle\BackBundle\Entity\ChCorporation;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

class EquipeController extends Controller
{
    public function indexAction(ChCorporation $idChCorporation)
    {
        // Récupération du championnat correspondant à la corporation CH
        $Championnat_actif = $idChCorporation->getChampionnatId();

        // On recupere les divisions associées au championnat (pour menu)
        $ChDivisions = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChDivision')
            ->getChDivision($Championnat_actif);

        // On recuperre les equipes de la corporation
        $ChEquipes = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChEquipe')
            ->getChEquipes($idChCorporation);

        // On recuperre les rencontre à venir de la corporation
        $rencontres_avenir = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontresCorporation($idChCorporation,'N');

        // On recuperre les rencontre jouées de la corporation
        $resultats = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontresCorporation($idChCorporation,'J');

        // On récupère les contacts de la corporations
        $contacts = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:Chjoueur')
            ->getContacts($idChCorporation);

        // On récupère les contacts de la corporations
        $joueursCorpoo = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:Chjoueur')
            ->getListeForceCorpo($idChCorporation);

        // On recupere les dernières news
         $lastNews = $this->get('app_repository_article')->getActiveArticles(5); 

        return $this->render('swsFrontBundle:Equipe:equipe.html.twig',array(
                'idChCorporation' => $idChCorporation,
                'ChDivisions' => $ChDivisions,
                'ChEquipes' => $ChEquipes,
                'Championnat_actif' => $Championnat_actif,
                'resultats' => $resultats,
                'rencontres_avenir' => $rencontres_avenir,
                'joueursCorpoo' => $joueursCorpoo,
                'contacts' => $contacts,
                'lastNews' =>$lastNews
            )
        );
    }

}
