<?php

namespace sws\Bundle\FrontBundle\Controller;

use sws\Bundle\FrontBundle\Entity\Post;
use sws\Bundle\BackBundle\Entity\ChDivision;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

class DivisionController extends Controller
{
    public function indexAction($slug)
    {

        // Récupération de l'entité chdivision
        $ChDivision = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDivision');

        $idChDivision = $ChDivision->findOneBy(array('slug' => $slug));
         

        // Récupération du championnat actif
        $Championnat_actif = $idChDivision->getChampionnatId();

        // Recherche des rencontres à venir pour la division (Service: RencontresDivision)
        $rencontresDivision = $this->get('RencontresDivision');
        $rencontresDivision->process($idChDivision, 'N', 'ASC',0);
        $rencontres_Division = $rencontresDivision->getRencontres();

        // Recherche des rencontres jouées pour la division (Service: RencontresDivision)
        $resultatsDivision = $this->get('RencontresDivision');
        $resultatsDivision->process($idChDivision, 'J', 'ASC',0);
        $resultats_Division = $resultatsDivision->getRencontres();

        // On recupere les divisions associées au championnat (pour menu)
        $ChDivisions = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChDivision')
            ->getChDivision($Championnat_actif);

        // Recherche du classement de la division (Service: ClassementDivision)
        $classements = $this->get('ClassementDivision');
        $classements->process($idChDivision);
        $classements_division = $classements->getEquipes();

        foreach ($classements_division as $item) {

            $ChCorporations[] = $item->getChcorporationId();

        }

        // On récupère les contacts des corporations (corpos référencées dans le classement ce la division)
        $contacts = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:Chjoueur')
            ->getContacts($ChCorporations);

        // On recupere le top 10 joueurs de la division
        $joueurTop10 = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:Championnat')
            ->getTopJoueurDivision($idChDivision);

        // On recupere les dernières news
         $lastNews = $this->get('app_repository_article')->getActiveArticles(5); 

        return $this->render('swsFrontBundle:Division:division.html.twig',array(
                'rencontres_Division' => $rencontres_Division,
                'idChDivision' => $idChDivision,
                'Championnat_actif' => $Championnat_actif,
                'ChDivisions' => $ChDivisions,
                'classements_division' => $classements_division,
                'joueurTop10'  => $joueurTop10,
                'resultats_Division' => $resultats_Division,
                'contacts' => $contacts,
                'lastNews' =>$lastNews
            )
        );
    }

}
