<?php

namespace sws\Bundle\FrontBundle\Controller;

use ED\BlogBundle\Model\Entity\Article;
use sws\Bundle\BackBundle\Entity\Championnat;
//use sws\Bundle\FrontBundle\Entity\Post;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

class DefaultController extends Controller
{
    public function indexAction()
    {
        // Récupération des 4 dernières news (module twig : 4.lastnews.html.twig)

       $listLastPost = $this->get('app_repository_article')->getActiveArticles(4);

        // Récupération du championnat actif

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat_actif = $repository->findOneBysetTdb(1);

        if (!$Championnat_actif) {

            echo 'CHAMPIONNAT ACTIF NON TROUVÉ';
            die();
        }

        // On recupere les divisions associées au championnat
        $ChDivisions = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChDivision')
            ->getChDivision($Championnat_actif);

        // On recupere le TOP 5 des joueurs
        $joueurTop5 = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:Championnat')
            ->getTopJoueur($Championnat_actif,6);

        // Recherche des rencontres pour le championnat actif (Service: RencontresChampionnatFront)

        $rencontresChampionnat = $this->get('RencontresChampionnatFront');
        $rencontresChampionnat->process($Championnat_actif, 'N', 'DESC',4);
        $rencontres_championnat = $rencontresChampionnat->getRencontres();

        // Recherche des classements du championnat actif (Service: ClassementsChampionnat)

        $classements = $this->get('ClassementsChampionnat');
        $classements->process($Championnat_actif);
        $classements_championnat = $classements->getEquipes();

        return $this->render('swsFrontBundle:Accueil:accueil.html.twig',array(
                'listLastPost' => $listLastPost,
                'rencontresChampionnat' => $rencontres_championnat,
                'classements_championnat' => $classements_championnat,
                'Championnat_actif' =>$Championnat_actif,
                'ChDivisions' => $ChDivisions,
                'joueurTop5' => $joueurTop5
            )
        );
    }

    public function redirectLoginAction()
    {
        $bag = $this->get('session')->getFlashBag();
        $bag->set('message', 'Vous êtes à présent connecté avec votre nouveau mot de passe.');

        return $this->redirect($this->generateUrl('sws_back_dashboard'));

    }

}
