<?php

namespace sws\Bundle\FrontBundle\Controller;

use ED\BlogBundle\Handler\Pagination;
use ED\BlogBundle\Model\Entity\Article;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;


class ActualiteController extends Controller
{
    public function indexAction()
    {
        /*

        $nbPerPage = 10; // Nombre de news par page

        // Récupération des news (via paginator)
        $lisArchivePosts = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsFrontBundle:Post')
            ->getArchivePosts($page, $nbPerPage);

        $nbPages = ceil(count($lisArchivePosts) / $nbPerPage);
        */

        // Récupération du championnat actif

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat_actif = $repository->findOneBysetTdb(1);

        if (!$Championnat_actif) {

            echo 'CHAMPIONNAT ACTIF NON TROUVÉ';
            die();
        }

        // On recupere les divisions associées au championnat
        $ChDivisions = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChDivision')
            ->getChDivision($Championnat_actif);


        $siteName = $this->container->getParameter('siteName');

        $seoPage = $this->container->get('sonata.seo.page');

        $seoPage
            ->setTitle('Actualité - '.$siteName)
        ;


        $paginator = $this->get('ed_blog.paginator');
        $response = $paginator->paginate(
            $this->get('app_repository_article')->getActiveArticles(),
            'swsFrontBundle:Archives_post:archivePosts',
            'swsFrontBundle:Archives_post:pagination',
            array(
                'ChDivisions' => $ChDivisions,
                'lisArchivePosts' => $this->get('app_repository_article')->getActiveArticles()
            ),
            Pagination::SMALL,
            //1,
            null,
            $paginationTemplate = 'swsFrontBundle:Archives_post:pagination.html.twig',
            array(),
            'sws_front_actualite'
        );

        return $response;
        /*


        return $this->render('swsFrontBundle:Archives_post:archivePosts.html.twig', array(
                'lisArchivePosts' => $lisArchivePosts,
                'Championnat_actif' => $Championnat_actif,
                'ChDivisions' => $ChDivisions,
                'nbPages' => $nbPages,
                'page' => $page,
            )
        );
        */

    }

    public function postAction($slug)
    {

        $article = $this->get('app_repository_article')->findBySlug($slug);

        if($article[0]->getStatus() != Article::STATUS_PUBLISHED  || !$article[0]->getPublishedAt() || strtotime($article[0]->getPublishedAt()->format("Y-m-d H:i:s") ) > strtotime(date("Y-m-d H:i:s")))
        {
            throw new NotFoundHttpException("Sorry, requested article is not longer available or your URL is wrong!");
        }

        $commentClass = $this->container->getParameter('blog_comment_class');
        $newComment = new $commentClass();
        $newComment
            ->setAuthor($this->getUser())
            ->setArticle($article[0]);

        $form = $this->createForm('edcomment', $newComment);
        $comments =  $this->get("app_repository_comment")->findByArticle($article[0], $this->get("blog_settings")->getCommentsDisplayOrder());
        $commentsCount = $this->get("app_repository_comment")->findCountByArticle($article[0]);

        // Récupération du championnat actif

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat_actif = $repository->findOneBysetTdb(1);

        if (!$Championnat_actif) {

            echo 'CHAMPIONNAT ACTIF NON TROUVÉ';
            die();
        }

        // On recupere les divisions associées au championnat
        $ChDivisions = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChDivision')
            ->getChDivision($Championnat_actif);

        $paginator = $this->get('ed_blog.paginator');
        $response = $paginator->paginate(
            $this->get('app_repository_article')->getActiveArticles(),
            'swsFrontBundle:Archives_post:post',
            'swsFrontBundle:Archives_post:pagination',
            array(
                'ChDivisions' => $ChDivisions,
                'lisArchivePosts' => $this->get('app_repository_article')->getActiveArticles(),
                'article' => $article[0],
                'form' => $form->createView(),
                'comments' => $comments,
                'commentsCnt' => $commentsCount,
                'ChDivisions' => $ChDivisions,
            ),
            Pagination::SMALL,
            //1,
            null,
            $paginationTemplate = 'swsFrontBundle:Archives_post:pagination.html.twig',
            array(),
            'sws_front_post'
        );
        return $response;            
    }
}
