<?php

namespace Front2Bundle\Menu;

use Knp\Menu\FactoryInterface;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerAwareTrait;

class Builder implements ContainerAwareInterface
{
    use ContainerAwareTrait;

    public function mainMenu(FactoryInterface $factory, array $options)
    {
        $menu = $factory->createItem('root');

        $menu->setChildrenAttribute('class', 'nav');
        //$menu->setLinkAttribute('class', 'text-uppercase');
        $menu->setAttribute('id', 'main');

        $menu->addChild('Acceuil', array(
            'route' => 'sws_front2_homepage',
            //'attributes' => array('class' => 'text-uppercase dropdown')
        ));

        /*

        $menu->addChild('Commandes', array(
            'uri' => '#',
            'label' => '<i class="fa fa-industry"></i>Commandes',
            'extras' => array('safe_label' => true),
            'attributes' => array('class' => 'text-uppercase dropdown dropdown-fw dropdown-fw-disabled')
        ));
        $menu['Commandes']->setChildrenAttribute('class', 'dropdown-menu dropdown-menu-fw');
        $menu['Commandes']->setLinkAttribute('class', 'text-uppercase');
        $menu['Commandes']->addChild('Liste', array(
            'route' => 'back_commandes',
            'label' => '<i class="fa fa-industry"></i>Liste',
            'extras' => array('safe_label' => true),
            'attributes' => array('class' => 'text-uppercase dropdown dropdown-fw dropdown-fw-disabled')
        ));
        $menu['Commandes']->setChildrenAttribute('class', 'dropdown-menu dropdown-menu-fw');
        $menu['Commandes']->setLinkAttribute('class', 'text-uppercase');
        $menu['Commandes']->addChild('Ajouter', array(
            'route' => 'back_add_commande',
            'label' => '<i class="fa fa-industry"></i>Ajouter',
            'extras' => array('safe_label' => true),
            'attributes' => array('class' => 'text-uppercase dropdown dropdown-fw dropdown-fw-disabled')
        ));

        $menu->addChild('Articles', array(
            'route' => 'back_articles',
            'label' => '<i class="fa fa-industry"></i>Articles',
            'extras' => array('safe_label' => true),
            'attributes' => array('class' => 'text-uppercase dropdown dropdown-fw dropdown-fw-disabled')
        ));


        // access services from the container!
        $em = $this->container->get('doctrine')->getManager();
        // findMostRecent and Blog are just imaginary examples
        $blog = $em->getRepository('BackBundle:Club')->getAll();

        $menu->addChild('Latest Blog Post', array(
        'route' => 'back_homepage'
        //'routeParameters' => array('id' => $blog->getId())
        ));

        $menu->addChild('Latest Blog Post2', array(
            'route' => 'back_homepage2'
            //'routeParameters' => array('id' => $blog->getId())
        ));

        // create another menu item
        $menu->addChild('About Me', array('route' => 'back_homepage'));
        // you can also add sub level's to your menu's as follows
        $menu['About Me']->addChild('Edit profile', array('route' => 'back_homepage'));

        // ... add more children

        */

        return $menu;
    }
}