<?php

namespace sws\Bundle\Front2Bundle\Controller;

use ED\BlogBundle\Model\Entity\Article;
use sws\Bundle\BackBundle\Entity\Championnat;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

class SallesController extends Controller
{
    public function indexAction()
    {
        // Récupération du championnat actif

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $championnatActif = $repository->findOneBysetTdb(1);

        if (!$championnatActif) {

            echo 'CHAMPIONNAT ACTIF NON TROUVÉ';
            die();
        }


        $listLastPost = $this->get('app_repository_article')->getActiveArticles(7);



        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSalle');
        $salles = $repository->findBy(
            array('championnat_id' => $championnatActif)
        );
        
        $siteName = $this->container->getParameter('siteName');
        $seoPage = $this->container->get('sonata.seo.page');
        $seoPage->setTitle('Salles - '.$siteName);  
            
        return $this->render('Front2Bundle:Salles:salles.html.twig',array(
                'championnatActif' =>$championnatActif,
                'listLastPost' => $listLastPost,
                'salles' => $salles
            )
        );
    }
}
