<?php

namespace sws\Bundle\Front2Bundle\Controller;

use ED\BlogBundle\Model\Entity\Article;
use Proxies\__CG__\sws\Bundle\BackBundle\Entity\ChJoueur;
use sws\Bundle\BackBundle\Entity\Championnat;
use sws\Bundle\BackBundle\Entity\ChPlanning;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\Routing\RequestContext;
use Symfony\Component\HttpFoundation\Request;

class RencontreController extends Controller
{
    public function showRencontreAction($idChPlanning, Request $request)
    {
        
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChPlanning');
        $rencontre = $repository->find($idChPlanning);
        
        
        // Récupération du championnat actif

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $championnatActif = $repository->findOneBysetTdb(1);

        if (!$championnatActif) {

            echo 'CHAMPIONNAT ACTIF NON TROUVÉ';
            die();
        }
        
         // On recupere les paramètres du championnat
        $chParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($championnatActif->getId());

        // On recupere les divisions associées au championnat
        $chDivisions = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChDivision')
            ->getChDivision($championnatActif);

        // Récupération des 4 dernières news

        $listLastPost = $this->get('app_repository_article')->getActiveArticles(7);

        // Récupération des articles "En vedette"
        $postFeatured = $this->get('app_repository_taxonomy')->findBySlug('en-vedette')->getArticles();


        // Recherche des classements du championnat actif (Service: ClassementsChampionnat)

        $classements = $this->get('ClassementsChampionnat');
        $classements->process($championnatActif);
        $classements_championnat = $classements->getEquipes();

       // On recupere les rencontres en retard
        $rencontresEnRetard = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreEnRetard($championnatActif->getId(), $chParametres->getNbJourRetard());


        // Recuperation des simples
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSimples');
        $rencontreSimple = $repository->findBy(array('chplanning_id' => $idChPlanning));

        // Recuperation des doubles
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDoubles');
        $rencontreDouble = $repository->findBy(array('chplanning_id' => $idChPlanning));

        // Recuperation les points des joueurs pour les simples
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChjoueurPtsSimple');
        $pointsJoueursSimple = $repository->findBy(array('chplanning_id' => $idChPlanning));

        // Recuperation les points des joueurs pour les doubles
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChjoueurPtsDouble');
        $pointsJoueursDouble = $repository->findBy(array('chplanning_id' => $idChPlanning));
       
        $siteName = $this->container->getParameter('siteName');
        $title = 'Rencontre : '.$rencontre->getChcorporationVisiteeId()->getCorporationId()->getNom().' vs '.$rencontre->getChcorporationVisiteuseId()->getCorporationId()->getNom().' (du '.$rencontre->getDateRencontre()->format('d-m-Y').')'.' - '.$siteName; 

        $manager = $this->get('templating.helper.assets');

        $seoPage = $this->container->get('sonata.seo.page');
        $seoPage->setTitle($title)
            ->addMeta('property', 'og:site_name', $siteName)
            ->addMeta('property', 'og:title', 'Rencontre : '.
                        $rencontre->getChcorporationVisiteeId()->getCorporationId()->getNom().
                        ' vs '.$rencontre->getChcorporationVisiteuseId()->getCorporationId()->getNom().
                        ' (du '.$rencontre->getDateRencontre()->format('d-m-Y').')'.
                        ': '.$rencontre->getPtsEquipeVisitee().'-'.$rencontre->getPtsEquipeVisiteuse())
            ->addMeta('property', 'og:type', 'article')
            ->addMeta('property', 'og:url', $request->getSchemeAndHttpHost().$this->generateUrl('sws_front2_rencontre', array('idChPlanning' => $rencontre->getId())))
            ->addMeta('property', 'og:image', $request->getSchemeAndHttpHost().$manager->getUrl('bundles/front2/images/logo_facebook.jpg'))
            ->addMeta('property', 'og:image:width', '527')
            ->addMeta('property', 'og:image:height', '351')
            ->addMeta('property', 'fb:app_id', '234402017434227')
            ->addMeta('property', 'og:description', 'Rencontre de '.
                        $rencontre->getChdivisionId()->getNom().' '.$rencontre->getChdivisionId()->getNumero().' '.$rencontre->getChdivisionId()->getSuffixe());
            


        
        return $this->render('Front2Bundle:Rencontre:rencontre.html.twig',array(
                'championnatActif' =>$championnatActif,
                'chDivisions' => $chDivisions,
                'listLastPost' => $listLastPost,
                'classements_championnat' => $classements_championnat,
                'rencontresEnRetard' => $rencontresEnRetard,
                'rencontreSimple' => $rencontreSimple,
                'rencontreDouble' => $rencontreDouble,
                'pointsJoueursSimple' => $pointsJoueursSimple,
                'pointsJoueursDouble' => $pointsJoueursDouble,
                'rencontre' => $rencontre
            )
        );
    }

}
