<?php

namespace sws\Bundle\Front2Bundle\Controller;

use ED\BlogBundle\Model\Entity\Article;
use Proxies\__CG__\sws\Bundle\BackBundle\Entity\ChJoueur;
use sws\Bundle\BackBundle\Entity\Championnat;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

class JoueursController extends Controller
{
    public function indexAction()
    {
        // Récupération du championnat actif

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $championnatActif = $repository->findOneBysetTdb(1);

        if (!$championnatActif) {

            echo 'CHAMPIONNAT ACTIF NON TROUVÉ';
            die();
        }
        
         // On recupere les paramètres du championnat
        $chParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($championnatActif->getId());

        // On recupere les divisions associées au championnat
        $chDivisions = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChDivision')
            ->getChDivision($championnatActif);

        // Récupération des 4 dernières news

        $listLastPost = $this->get('app_repository_article')->getActiveArticles(7);

        // Récupération des articles "En vedette"
        $postFeatured = $this->get('app_repository_taxonomy')->findBySlug('en-vedette')->getArticles();


        // Recherche des classements du championnat actif (Service: ClassementsChampionnat)

        $classements = $this->get('ClassementsChampionnat');
        $classements->process($championnatActif);
        $classements_championnat = $classements->getEquipes();


        // Recherche des rencontres pour le championnat actif (Service: RencontresChampionnatFront)
        /*
        $rencontresChampionnat = $this->get('RencontresChampionnatFront');
        $rencontresChampionnat->process($championnatActif, 'N', 'DESC',4);
        $rencontresSemaineSuivante = $rencontresChampionnat->getRencontres();
        */
        /*
        // On recupere les rencontres de la semaine précédente
        $rencontreSemainePrecedente = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreSemainePrecedente($championnatActif); 
            
        // On recupere les rencontres de la semaine en cours
        $rencontreSemaineEncCours = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreSemaineEncours($championnatActif);        

        // On recupere les rencontres de la semaine suivante
        $rencontreSemaineSuivante = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreSemaineSuivante($championnatActif);    
        */

       // On recupere les rencontres en retard
        $rencontresEnRetard = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreEnRetard($championnatActif->getId(), $chParametres->getNbJourRetard());


        // On recuperre les joueurs du championnat
        $ChJoueurs = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChJoueur')
            ->getChJoueursChampionnat($championnatActif->getId());
            
        $siteName = $this->container->getParameter('siteName');
        $seoPage = $this->container->get('sonata.seo.page');
        $seoPage->setTitle('Joueurs - '.$siteName);            
            
        return $this->render('Front2Bundle:Joueurs:joueurs.html.twig',array(
                'championnatActif' =>$championnatActif,
                'chDivisions' => $chDivisions,
                'listLastPost' => $listLastPost,
                'classements_championnat' => $classements_championnat,
                'ChJoueurs' => $ChJoueurs,
                'rencontresEnRetard' => $rencontresEnRetard
            )
        );
    }

    public function joueurAction($slugJoueur)
    {
        // Récupération du championnat actif

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $championnatActif = $repository->findOneBysetTdb(1);

        if (!$championnatActif) {

            echo 'CHAMPIONNAT ACTIF NON TROUVÉ';
            die();
        }

        // On recupere les paramètres du championnat
        $chParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($championnatActif->getId());

        // Récupération des 4 dernières news

        $listLastPost = $this->get('app_repository_article')->getActiveArticles(4);

        $classements = $this->get('ClassementsChampionnat');
        $classements->process($championnatActif);
        $classements_championnat = $classements->getEquipes();

        // Récupération du joueur si passé en paramètre
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
        $joueur = $repository->findOneBySlug($slugJoueur);

        // On récupère les joueurs de la corporation
        $joueursCorpo = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:Chjoueur')
            ->getListeForceCorpo($joueur->getChcorporationId());


        // Recuperation les points du joueur pour les simples
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChjoueurPtsSimple');
        $joueurPtsSimples = $repository->findBy(array('chjoueurId' => $joueur));

        // Recuperation les points du joueur pour les doubles
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChjoueurPtsDouble');
        $joueurPtsDoubles = $repository->findBy(array('chjoueurId' => $joueur));


        // On recupere les simples du joueur
        $joueurSimples = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChSimples')
            ->getSimplesCh($joueur);


        // On recupere les doubles du joueur
        $joueurDoubles = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChDoubles')
            ->getDoublesCh($joueur);

        // On recupere le classement des joueurs de la corpo
        $classementJoueursCorpo = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:Championnat')
            ->getTopJoueurCorpo($joueur->getChcorporationId()->getId());

        // On récupère les contacts de la corporations
        $contacts = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:Chjoueur')
            ->getContacts($joueur->getChcorporationId());
            
        $siteName = $this->container->getParameter('siteName');
        $seoPage = $this->container->get('sonata.seo.page');
        $seoPage->setTitle($joueur->getJoueurId()->getNom().' '.$joueur->getJoueurId()->getPrenom().' ('.$joueur->getChcorporationId()->getCorporationId()->GetNom().')'.' - '.$siteName);            

        return $this->render('Front2Bundle:Joueurs:joueur.html.twig',array(
                'championnatActif' =>$championnatActif,
                'listLastPost' => $listLastPost,
                'classements_championnat' => $classements_championnat,
                'joueursCorpo' => $joueursCorpo,
                'contacts' => $contacts,
                'classementJoueursCorpo' => $classementJoueursCorpo,
                'joueur' => $joueur,
                'joueurSimples' => $joueurSimples,
                'joueurDoubles' => $joueurDoubles,
                'joueurPtsSimples' => $joueurPtsSimples ,
                'joueurPtsDoubles' => $joueurPtsDoubles

            )
        );
    }

}
