<?php

namespace sws\Bundle\Front2Bundle\Controller;

use ED\BlogBundle\Model\Entity\Article;
use sws\Bundle\BackBundle\Entity\Championnat;
use sws\Bundle\BackBundle\Entity\ChEquipe;
use sws\Bundle\BackBundle\Entity\ChJoueur;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

class EquipesController extends Controller
{

    public function showEquipeAction(ChEquipe $equipe, $slugJoueur)
    {
        // Récupération du championnat actif

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $championnatActif = $repository->findOneBysetTdb(1);

        if (!$championnatActif) {

            echo 'CHAMPIONNAT ACTIF NON TROUVÉ';
            die();
        }
        
         // On recupere les paramètres du championnat
        $chParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($championnatActif->getId());

        // On recupere les divisions associées au championnat
        $chDivisions = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChDivision')
            ->getChDivision($championnatActif);

        // Récupération des 4 dernières news

        $listLastPost = $this->get('app_repository_article')->getActiveArticles(4);

        // Récupération des articles "En vedette"
        //$postFeatured = $this->get('app_repository_taxonomy')->findBySlug('en-vedette')->getArticles();

        // Recherche du classements de la division de l'équipe
        /*
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
        $classements_championnat = $repository->findBy(
            array(
                'championnat_id' => $championnatActif,
                'chdivision_id' => $equipe->getChdivisionId()

            ),
            array(
                'calculPtsEquipe' => 'DESC'
            )
        );
        */

        $classements = $this->get('ClassementsChampionnat');
        $classements->process($championnatActif);
        $classements_championnat = $classements->getEquipes();

        // Recherche des rencontres pour le championnat actif (Service: RencontresChampionnatFront)
        /*
        $rencontresChampionnat = $this->get('RencontresChampionnatFront');
        $rencontresChampionnat->process($championnatActif, 'N', 'DESC',4);
        $rencontresSemaineSuivante = $rencontresChampionnat->getRencontres();
        */
        /*
        // On recupere les rencontres de la semaine précédente
        $rencontreSemainePrecedente = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreSemainePrecedente($championnatActif); 
            
        // On recupere les rencontres de la semaine en cours
        $rencontreSemaineEncCours = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreSemaineEncours($championnatActif);        
            
        // On recupere les rencontres de la semaine suivante
        $rencontreSemaineSuivante = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreSemaineSuivante($championnatActif);    
            
       // On recupere les rencontres en retard
        $rencontresEnRetard = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreEnRetard($championnatActif->getId(), $chParametres->getNbJourRetard());
        */

        // On recuperre les corporations du championnat
        $ChCorporations = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChCorporation')
            ->getChCorporation($championnatActif);

        // On recuperre les rencontres jouées de l'équipe
        $rencontresJoueesEquipe = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontresEquipeAvecStatus($equipe->getId(), 'J');

        // On recuperre les rencontres jouées de l'équipe
        $rencontresForfaitEquipe = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontresEquipeAvecStatus($equipe->getId(), 'F');

        // On recuperre les rencontre non jouées de l'équipe
        $rencontresNonJoueesEquipe = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontresEquipeAvecStatus($equipe->getId(), 'N');

        if ($rencontresJoueesEquipe){

            // Recuperation des simples
            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSimples');
            $rencontreSimple = $repository->findBy(array('chplanning_id' => $rencontresJoueesEquipe[0]->getId()));

            // Recuperation des doubles
            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDoubles');
            $rencontreDouble = $repository->findBy(array('chplanning_id' => $rencontresJoueesEquipe[0]->getId()));
        }
        else{
            $rencontreSimple = Null;
            $rencontreDouble = Null;

        };


        if ($equipe->getChcorporationId()->getCorporationId()->getGenre() == 'F'){

            // On recupere la liste de force de la corpoCH Dame
            $joueursCorpo = $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:ChJoueur')
                ->getListeForceCorpoDames($equipe->getChcorporationId());
        }
        else{

            // On recupere la liste de force de la corpoCH Mixte et Homme
            $joueursCorpo = $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:ChJoueur')
                ->getListeForceCorpo($equipe->getChcorporationId());
        }


        // Récupération du joueur si passé en paramètre
        if ($slugJoueur != 'no#critere'){
            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur = $repository->findOneBySlug($slugJoueur);
            $overview = false;
        }
        else{

            $joueur = $joueursCorpo[0];
            $overview = true;

        };

           
        // Recuperation les points du joueur pour les simples
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChjoueurPtsSimple');
        $joueurPtsSimples = $repository->findBy(array('chjoueurId' => $joueur));

        // Recuperation les points du joueur pour les doubles
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChjoueurPtsDouble');
        $joueurPtsDoubles = $repository->findBy(array('chjoueurId' => $joueur));  
        

        // On recupere les simples du joueur
        $joueurSimples = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChSimples')
            ->getSimplesCh($joueur);
            

        // On recupere les doubles du joueur
        $joueurDoubles = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChDoubles')
            ->getDoublesCh($joueur);  

        // On recupere le classement des joueurs de la corpo
        $classementJoueursCorpo = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:Championnat')
            ->getTopJoueurCorpo($equipe->getChcorporationId()->getId());

        // On récupère les contacts de la corporations
        $contacts = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:Chjoueur')
            ->getContacts($equipe->getChcorporationId());

        $siteName = $this->container->getParameter('siteName');
        $seoPage = $this->container->get('sonata.seo.page');
        $seoPage->setTitle($equipe->getNom().' '.$equipe->getNumeroEquipe().' '.$equipe->getSuffixEquipe().'('.$equipe->getChcorporationId()->getCorporationId()->getNom().')'.' - '.$siteName); 
            
        return $this->render('Front2Bundle:Equipes:equipe.html.twig',array(
                'championnatActif' =>$championnatActif,
                'chDivisions' => $chDivisions,
                'listLastPost' => $listLastPost,
                'classements_championnat' => $classements_championnat,
                //'postFeatured' => $postFeatured,
                'ChCorporations' => $ChCorporations,
                'equipe' => $equipe,
                'rencontresJoueesEquipe' => $rencontresJoueesEquipe,
                'rencontresNonJoueesEquipe' => $rencontresNonJoueesEquipe,
                'rencontreSimple' => $rencontreSimple,
                'rencontreDouble' => $rencontreDouble,
                'joueursCorpo' => $joueursCorpo,
                'contacts' => $contacts,
                'classementJoueursCorpo' => $classementJoueursCorpo,
                'joueur' => $joueur,
                'overview' => $overview,
                'joueurSimples' => $joueurSimples,
                'joueurDoubles' => $joueurDoubles,
                'joueurPtsSimples' => $joueurPtsSimples ,
                'joueurPtsDoubles' => $joueurPtsDoubles,
                'rencontresForfaitEquipe' => $rencontresForfaitEquipe

            )
        );
    }
}
