<?php

namespace sws\Bundle\Front2Bundle\Controller;

use sws\Bundle\BackBundle\Entity\Championnat;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

class DocumentsController extends Controller
{
    public function indexAction()
    {
        // Récupération du championnat actif

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $championnatActif = $repository->findOneBysetTdb(1);

        if (!$championnatActif) {

            echo 'CHAMPIONNAT ACTIF NON TROUVÉ';
            die();
        }

        // Récupération des 7 dernières news

        $listLastPost = $this->get('app_repository_article')->getActiveArticles(7);
        
        $siteName = $this->container->getParameter('siteName');
        $seoPage = $this->container->get('sonata.seo.page');
        $seoPage->setTitle('Documents - '.$siteName);          
            
        return $this->render('Front2Bundle:Documents:documents.html.twig',array(
                'championnatActif' =>$championnatActif,
                'listLastPost' => $listLastPost
            )
        );
    }
}
