<?php

namespace sws\Bundle\Front2Bundle\Controller;

use ED\BlogBundle\Model\Entity\Article;
use sws\Bundle\BackBundle\Entity\Championnat;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

class DivisionsController extends Controller
{
    public function indexAction()
    {
        // Récupération du championnat actif

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $championnatActif = $repository->findOneBysetTdb(1);

        if (!$championnatActif) {

            echo 'CHAMPIONNAT ACTIF NON TROUVÉ';
            die();
        }

         // On recupere les paramètres du championnat
        $chParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($championnatActif->getId());

        // On recupere les divisions associées au championnat
        $chDivisions = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChDivision')
            ->getChDivision($championnatActif);

        // Récupération des 4 dernières news

        $listLastPost = $this->get('app_repository_article')->getActiveArticles(7);

        // Récupération des articles "En vedette"
        $postFeatured = $this->get('app_repository_taxonomy')->findBySlug('en-vedette')->getArticles();


        // Recherche des classements du championnat actif (Service: ClassementsChampionnat)

        $classements = $this->get('ClassementsChampionnat');
        $classements->process($championnatActif);
        $classements_championnat = $classements->getEquipes();


       // On recupere les rencontres en retard
        $rencontresEnRetard = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreEnRetard($championnatActif->getId(), $chParametres->getNbJourRetard());


        // On recuperre les équipes du championnat
        $ChEquipes = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChEquipe')
            ->getChEquipesChampionnat($championnatActif);

        $siteName = $this->container->getParameter('siteName');
        $seoPage = $this->container->get('sonata.seo.page');
        $seoPage->setTitle('Divisions - '.$siteName);  
        
        return $this->render('Front2Bundle:Divisions:divisions.html.twig',array(
                'championnatActif' =>$championnatActif,
                'chDivisions' => $chDivisions,
                'listLastPost' => $listLastPost,
                'classements_championnat' => $classements_championnat,
                'rencontresEnRetard' => $rencontresEnRetard
            )
        );
    }

    public function showDivisionAction($slugDivision){

        // Récupération du championnat actif

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $championnatActif = $repository->findOneBysetTdb(1);

        if (!$championnatActif) {

            echo 'CHAMPIONNAT ACTIF NON TROUVÉ';
            die();
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDivision');
        $chDivision = $repository->findOneByslug($slugDivision);

        if (!$chDivision) {
            throw $this->createNotFoundException("La chDivision avec le slug ".$slugDivision." n'existe pas.");
        }

        $listLastPost = $this->get('app_repository_article')->getActiveArticles(7);

        // On recupere les paramètres du championnat
        $chParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($championnatActif->getId());

        // On recupere les divisions associées au championnat
        $chDivisions = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChDivision')
            ->getChDivision($championnatActif);

        $classements = $this->get('ClassementsChampionnat');
        $classements->process($championnatActif);
        $classements_championnat = $classements->getEquipes();

        // On recuperre les corporations du championnat
        $ChCorporations = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChCorporation')
            ->getChCorporation($championnatActif);

        $rencontresJoueesDivision = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontresDivisionByStatus($chDivision->getId(), 'J');

        $rencontresForfaitDivision = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontresDivisionByStatus($chDivision->getId(), 'F');

        $rencontresNonJoueesDivision = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontresDivisionByStatus($chDivision->getId(), 'N');

        $classementDivision = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChEquipe')
            ->getClassement($chDivision);

        $contactsDivision = array(array());
        $ind = 1;
        foreach ($classementDivision as $equipe){

            $contactsDivision[$ind][]= $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:ChJoueur')
                ->getContactsEquipe($equipe->getChCorporationId()->getId(),$equipe->getId());

            $ind++;
        }
        
        $siteName = $this->container->getParameter('siteName');
        $seoPage = $this->container->get('sonata.seo.page');
        $seoPage->setTitle($chDivision->getNom().' '.$chDivision->getNumero().' '.$chDivision->getSuffixe().' - '.$siteName);  

        return $this->render('Front2Bundle:Divisions:division.html.twig',array(
                'championnatActif' =>$championnatActif,
                'chDivisions' => $chDivisions,
                'classements_championnat' => $classements_championnat,
                'ChCorporations' => $ChCorporations,
                'chDivision' => $chDivision,
                'listLastPost' => $listLastPost,
                'rencontresJoueesDivision' => $rencontresJoueesDivision,
                'rencontresNonJoueesDivision' => $rencontresNonJoueesDivision,
                'classementDivision' => $classementDivision,
                'contactsDivision' => $contactsDivision,
                'rencontresForfaitDivision' => $rencontresForfaitDivision
            )
        );

    }
}
