<?php

namespace sws\Bundle\Front2Bundle\Controller;

use ED\BlogBundle\Model\Entity\Article;
use sws\Bundle\BackBundle\Entity\Championnat;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

class CorporationsController extends Controller
{
    public function indexAction()
    {
        // Récupération du championnat actif

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $championnatActif = $repository->findOneBysetTdb(1);

        if (!$championnatActif) {

            echo 'CHAMPIONNAT ACTIF NON TROUVÉ';
            die();
        }
        
         // On recupere les paramètres du championnat
        $chParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($championnatActif->getId());

        // On recupere les divisions associées au championnat
        $chDivisions = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChDivision')
            ->getChDivision($championnatActif);

        // Récupération des 4 dernières news

        $listLastPost = $this->get('app_repository_article')->getActiveArticles(7);

        // Récupération des articles "En vedette"
        $postFeatured = $this->get('app_repository_taxonomy')->findBySlug('en-vedette')->getArticles();


        // Recherche des classements du championnat actif (Service: ClassementsChampionnat)

        $classements = $this->get('ClassementsChampionnat');
        $classements->process($championnatActif);
        $classements_championnat = $classements->getEquipes();


        // Recherche des rencontres pour le championnat actif (Service: RencontresChampionnatFront)
        /*
        $rencontresChampionnat = $this->get('RencontresChampionnatFront');
        $rencontresChampionnat->process($championnatActif, 'N', 'DESC',4);
        $rencontresSemaineSuivante = $rencontresChampionnat->getRencontres();
        */
        /*
        // On recupere les rencontres de la semaine précédente
        $rencontreSemainePrecedente = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreSemainePrecedente($championnatActif); 
            
        // On recupere les rencontres de la semaine en cours
        $rencontreSemaineEncCours = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreSemaineEncours($championnatActif);        
            
        // On recupere les rencontres de la semaine suivante
        $rencontreSemaineSuivante = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreSemaineSuivante($championnatActif);    
        */

       // On recupere les rencontres en retard
        $rencontresEnRetard = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreEnRetard($championnatActif->getId(), $chParametres->getNbJourRetard());


        // On recuperre les équipes du championnat
        $ChEquipes = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChEquipe')
            ->getChEquipesChampionnat($championnatActif);

        $ind = 0;
        $ChEquipes2 = array( array(), array());

        foreach ($ChEquipes as $equipe){

            $ChEquipes2[$ind][] = $equipe;

            $delegue = $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:ChJoueur')
                ->getDelegues($equipe->getChCorporationId());

            if ($delegue){

                $ChEquipes2[$ind][] = $delegue;

            }
            else{
                $ChEquipes2[$ind][] = null;
            }

            $ind++;

        }
        
        $siteName = $this->container->getParameter('siteName');
        $seoPage = $this->container->get('sonata.seo.page');
        $seoPage->setTitle('Equipes - '.$siteName);
            
        return $this->render('Front2Bundle:Corporations:corporations.html.twig',array(
                'championnatActif' =>$championnatActif,
                'chDivisions' => $chDivisions,
                'listLastPost' => $listLastPost,
                'classements_championnat' => $classements_championnat,
                'ChEquipes' => $ChEquipes2,
                'rencontresEnRetard' => $rencontresEnRetard
            )
        );
    }

    public function redirectLoginAction()
    {
        $bag = $this->get('session')->getFlashBag();
        $bag->set('message', 'Vous êtes à présent connecté avec votre nouveau mot de passe.');

        return $this->redirect($this->generateUrl('sws_back_dashboard'));

    }

}
