<?php

namespace sws\Bundle\Front2Bundle\Controller;

use ED\BlogBundle\Model\Entity\Article;
use sws\Bundle\BackBundle\Entity\Championnat;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;

use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Gregwar\CaptchaBundle\Type\CaptchaType;

class ContactController extends Controller
{
    public function indexAction(Request $request)
    {
        // Récupération du championnat actif

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $championnatActif = $repository->findOneBysetTdb(1);

        if (!$championnatActif) {

            echo 'CHAMPIONNAT ACTIF NON TROUVÉ';
            die();
        }

        // Récupération des 4 dernières news

        $listLastPost = $this->get('app_repository_article')->getActiveArticles(7);

        $form = $this->createFormBuilder()
            ->add('nom', TextType::class)
            ->add('sujet', TextType::class)
            ->add('email', EmailType::class)
            ->add('message',TextareaType::class)
            ->add('captcha', CaptchaType::class, array(
                'width' => 200,
                'height' => 50,
                'length' => 6,
                'reload' => true,
                'as_url' => true,
                'background_color' => array(255,255,255),
                'quality' => 100
            ))
            ->add('submit', SubmitType::class, array('label' => 'Envoyer'))
            ->getForm();

        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {

            $mail = $form->getData();
            $message = (new \Swift_Message('RILTENNIS : Formulaire de contact'))
                ->setFrom($mail['email'])
                ->setTo('comite@riltennis.org')
                ->setBody('Message de la part de '.$mail['nom'].'('.$mail['email'].')'.'<br><br>Message :<br>'.$mail['message'],'text/html')
            ;

            $this->get('mailer')->send($message);

            return $this->redirectToRoute('sws_front2_contact');
        }

        $siteName = $this->container->getParameter('siteName');
        $seoPage = $this->container->get('sonata.seo.page');
        $seoPage->setTitle('Contacts - '.$siteName);

        return $this->render('Front2Bundle:Contact:contact.html.twig',array(
                'championnatActif' =>$championnatActif,
                'listLastPost' => $listLastPost,
                'form' => $form->createView()
            )
        );

    }
}
