<?php

namespace sws\Bundle\Front2Bundle\Controller;

use ED\BlogBundle\Handler\Pagination;
use ED\BlogBundle\Model\Entity\Article;
use sws\Bundle\BackBundle\Entity\Championnat;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\Routing\RequestContext;
use Symfony\Component\HttpFoundation\Request;

class ArticlesController extends Controller
{
    public function indexAction()
    {
        // Récupération du championnat actif

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $championnatActif = $repository->findOneBysetTdb(1);

        if (!$championnatActif) {

            echo 'CHAMPIONNAT ACTIF NON TROUVÉ';
            die();
        }
        
         // On recupere les paramètres du championnat
        $chParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($championnatActif->getId());

        // On recupere les divisions associées au championnat
        $chDivisions = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChDivision')
            ->getChDivision($championnatActif);

        // Récupération des 7 dernières news

        $listLastPost = $this->get('app_repository_article')->getActiveArticles(7);

        // Récupération des articles "En vedette"
        $postFeatured = $this->get('app_repository_taxonomy')->findBySlug('en-vedette')->getArticles();


        // Recherche des classements du championnat actif (Service: ClassementsChampionnat)

        $classements = $this->get('ClassementsChampionnat');
        $classements->process($championnatActif);
        $classements_championnat = $classements->getEquipes();


        // Recherche des rencontres pour le championnat actif (Service: RencontresChampionnatFront)
        /*
        $rencontresChampionnat = $this->get('RencontresChampionnatFront');
        $rencontresChampionnat->process($championnatActif, 'N', 'DESC',4);
        $rencontresSemaineSuivante = $rencontresChampionnat->getRencontres();
        */
        
        // On recupere les rencontres de la semaine précédente
        $rencontreSemainePrecedente = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreSemainePrecedente($championnatActif); 
            
        // On recupere les rencontres de la semaine en cours
        $rencontreSemaineEncCours = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreSemaineEncours($championnatActif);        
            
        // On recupere les rencontres de la semaine suivante
        $rencontreSemaineSuivante = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreSemaineSuivante($championnatActif);    
             
       // On recupere les rencontres en retard
        $rencontresEnRetard = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreEnRetard($championnatActif->getId(), $chParametres->getNbJourRetard());

        // On recuperre les corporations du championnat
        $ChCorporations = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChCorporation')
            ->getChCorporation($championnatActif);
            
        $siteName = $this->container->getParameter('siteName');
        $seoPage = $this->container->get('sonata.seo.page');
        $seoPage->setTitle('Articles - '.$siteName);

        $paginator = $this->get('ed_blog.paginator');
        $response = $paginator->paginate(
            $this->get('app_repository_article')->getActiveArticles(),
            'Front2Bundle:Articles:articles',
            'Front2Bundle:Articles:pagination',
            array(
                'championnatActif' =>$championnatActif,
                'chDivisions' => $chDivisions,
                'listLastPost' => $this->get('app_repository_article')->getActiveArticles(),
                'classements_championnat' => $classements_championnat,
                'postFeatured' => $postFeatured,
                'ChCorporations' => $ChCorporations,
                'rencontresEnRetard' => $rencontresEnRetard,
                'rencontreSemainePrecedente' => $rencontreSemainePrecedente,
                'rencontreSemaineEncCours' => $rencontreSemaineEncCours,
                'rencontresSemaineSuivante' => $rencontreSemaineSuivante
            ),
            Pagination::SMALL,
            //1,
            null,
            $paginationTemplate = 'Front2Bundle:Articles:pagination.html.twig',
            array(),
            'sws_front2_articles'
        );

        return $response;
    }
    
    public function showArticleAction($slug,Request $request)
    {
    
        $post= $this->get('app_repository_article')->findBySlug($slug);

        if($post[0]->getStatus() != Article::STATUS_PUBLISHED  || !$post[0]->getPublishedAt() || strtotime($post[0]->getPublishedAt()->format("Y-m-d H:i:s") ) > strtotime(date("Y-m-d H:i:s")))
        {
            throw new NotFoundHttpException("Sorry, requested article is not longer available or your URL is wrong!");
        }
        // Récupération du championnat actif

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $championnatActif = $repository->findOneBysetTdb(1);

        if (!$championnatActif) {

            echo 'CHAMPIONNAT ACTIF NON TROUVÉ';
            die();
        }
        
         // On recupere les paramètres du championnat
        $chParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($championnatActif->getId());

        // On recupere les divisions associées au championnat
        $chDivisions = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChDivision')
            ->getChDivision($championnatActif);

        // Récupération des 4 dernières news

        $listLastPost = $this->get('app_repository_article')->getActiveArticles(10);

        // Récupération des articles "En vedette"
        $postFeatured = $this->get('app_repository_taxonomy')->findBySlug('en-vedette')->getArticles();


        // Recherche des classements du championnat actif (Service: ClassementsChampionnat)

        $classements = $this->get('ClassementsChampionnat');
        $classements->process($championnatActif);
        $classements_championnat = $classements->getEquipes();

       
        // On recupere les rencontres de la semaine précédente
        $rencontreSemainePrecedente = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreSemainePrecedente($championnatActif); 
            
        // On recupere les rencontres de la semaine en cours
        $rencontreSemaineEncCours = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreSemaineEncours($championnatActif);        
            
        // On recupere les rencontres de la semaine suivante
        $rencontreSemaineSuivante = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreSemaineSuivante($championnatActif);    
             
       // On recupere les rencontres en retard
        $rencontresEnRetard = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreEnRetard($championnatActif->getId(), $chParametres->getNbJourRetard());

        // On recuperre les equipes de la corporation
        $ChCorporations = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChCorporation')
            ->getChCorporation($championnatActif);
            
        $provider = $this->container->get($post[0]->getExcerptPhoto()->getProviderName());
        $url = 'http://www.riltennis.org'.$provider->generatePublicUrl($post[0]->getExcerptPhoto(), 'default_big');

        $siteName = $this->container->getParameter('siteName');

        $seoPage = $this->container->get('sonata.seo.page');

        $seoPage
            ->setTitle($post[0]->getTitle().' - '.$siteName )
            ->addMeta('property', 'og:site_name', $siteName)
            ->addMeta('property', 'og:title', $post[0]->getTitle())
            ->addMeta('property', 'og:type', 'article')
            ->addMeta('property', 'og:url', $request->getSchemeAndHttpHost().$this->generateUrl('sws_front2_article', array('slug' => $slug)))
            ->addMeta('property', 'og:image', $url)
            ->addMeta('property', 'og:image:width', '527')
            ->addMeta('property', 'og:image:height', '351')
            ->addMeta('property', 'fb:app_id', '234402017434227')
            ->addMeta('property', 'og:description', $post[0]->getContent());

        return $this->render('Front2Bundle:Articles:article.html.twig',array(
                'post' =>$post,
                'championnatActif' =>$championnatActif,
                'chDivisions' => $chDivisions,
                'listLastPost' => $listLastPost,
                'classements_championnat' => $classements_championnat,
                'postFeatured' => $postFeatured,
                'ChCorporations' => $ChCorporations,
                'rencontresEnRetard' => $rencontresEnRetard,
                'rencontreSemainePrecedente' => $rencontreSemainePrecedente,
                'rencontreSemaineEncCours' => $rencontreSemaineEncCours,
                'rencontresSemaineSuivante' => $rencontreSemaineSuivante                
            )
        );
    }    

    public function redirectLoginAction()
    {
        $bag = $this->get('session')->getFlashBag();
        $bag->set('message', 'Vous êtes à présent connecté avec votre nouveau mot de passe.');

        return $this->redirect($this->generateUrl('sws_back_dashboard'));

    }

}
