<?php

namespace sws\Bundle\BackBundle\Services;

/**
 * Class SlotsChampionnat
 * @package sws\Bundle\BackBundle\Services
 */
class SlotsChampionnat
{

    /**
     * @var
     */
    private $Slots;

    /**
     * @return mixed
     */
    public function getSlots()
    {
        return $this->Slots;
    }

    /**
     * @param $dateDebut
     * @param $DateFin
     * @return bool|object
     */
    public function processSlots($championnat, $locations, $jourFerie, $dateTournois)
    {
        // Cette fonction retourne les créneaux horaires du championnat en fonction du debut/fin du championnat et des locations encodées
        // Créneau horaire --> Date disponible pour planifier une rencontre

        $iStart = strtotime ($championnat->getDateDebut()->format("Y-m-d"));
        $iEnd = strtotime ($championnat->getDateFin()->format("Y-m-d"));

        if (false === $iStart || false === $iEnd) {
            return false;
        }

        $aStart = explode ('-',$championnat->getDateDebut()->format("Y-m-d"));
        $aEnd = explode ('-', $championnat->getDateFin()->format("Y-m-d"));

        if (count ($aStart) !== 3 || count ($aEnd) !== 3) {
            return false;
        }
        if (false === checkdate ($aStart[1], $aStart[2], $aStart[0]) || false === checkdate ($aEnd[1], $aEnd[2], $aEnd[0]) || $iEnd <= $iStart) {
            return false;
        }

        // Paracourir toutes les dates entre le début et la fin du championnat (jour par jour)

        $total_creneaux = 0;
        for ($i = $iStart; $i < $iEnd + 86400; $i = strtotime ('+1 day', $i) ) {
            $sDateToArr = strftime ('%Y-%m-%d', $i);
            $sYear = substr ($sDateToArr, 0, 4);
            $sMonth = substr ($sDateToArr, 5, 2);
            $sDay = substr ($sDateToArr, 8, 2);

            $timestamp = mktime(0, 0, 0, $sMonth,$sDay, $sYear);
            $jour = date('w', $timestamp);

            // Vérifier si le créneau horaire est à reprendre dans le planning (en fonction des jours de locations)

            foreach ($locations as $keys => $var){

                $var_jour = $var->getJour();
                if ( $var_jour == 7) {

                     $var_jour = 0;
                }

                if (($jour) ==  $var_jour){

                    // Si le jour de la date $sDateToArr (date itérée par la boucle) est trouvée dans les créneaux horaires,
                    // on la sauve dans le tableau

                    // Si la date est incluse dans le tableau des jours fériés -> on ne la reprend pas
                    $isFerie = false;
                    foreach ($jourFerie as $keys2 => $ferie){

                        $debut = date_format($ferie->getPeriodeDebut(),"Y-m-d");
                        $fin = date_format($ferie->getPeriodeFin(),"Y-m-d");

                        if ( $sDateToArr >= $debut and $sDateToArr <= $fin ){

                            $isFerie = true;
                            break;

                        }
                    }

                    if ($isFerie == false){
                        // Si la date n'est pas incluse dans les jours fériés mais qu'elle est incluse dans le tableau des dates de tournoi, on ne la reprend pas pour la salle impactée

                        $isTournois = false;
                        foreach ($dateTournois as $keys3 => $tournois) {

                            $debut = date_format($tournois->getPeriodeDebut(),"Y-m-d");
                            $fin = date_format($tournois->getPeriodeFin(),"Y-m-d");

                            if ( $sDateToArr >= $debut and $sDateToArr <= $fin and $tournois->getChSalleId() == $var->getChSalleId() ){

                                // On évince les locations avec le même ChSalleId que les contraintes de salle avec le même CHSalleId

                                $isTournois = true;
                                break;
                            }
                        }
                        if ($isTournois == false) {
                            $Slots[$sDateToArr][$var->getChsalleId()->getId()][$var->getnumeroRencontre()] = $var;
                        }
                    }
                }
            }
        }

        if (isset ($Slots)){
            $this->Slots = (object) $Slots;
        }
        else{
            $this->$Slots = null;
        }
    }
}