<?php

namespace sws\Bundle\BackBundle\Services;

/**
 * Class SanitizeFileName
 *
 * @package sws\Bundle\BackBundle\Services
 */
class SanitizeFileName
{
    /**
     * @var
     */
    private $fileName;

    /**
     * @return mixed
     */
    public function getFileName()
    {
        return $this->fileName;
    }

    /**
     * Corrige le nom du fichier en entrée
     *
     *
     */
    public function processSanitizeFileNamle($inputfileName)
    {

        $string = strtolower($inputfileName);

        $string = str_replace ("ê", "e", $string);
        $string = str_replace ("é", "e", $string);
        $string = str_replace ("è", "e", $string);
        $string = str_replace ("à", "a", $string);

        $string = str_replace (" ", "_", $string);
        $string = str_replace ("..", ".", $string);

        preg_replace ("/[^0-9^a-z^_^.]/", "", $string);

        $this->fileName = $string;
    }
}