<?php

namespace sws\Bundle\BackBundle\Services;

/**
 * Class SlotsChampionnat
 * @package sws\Bundle\BackBundle\Services
 */
class RoundRobinChampionnat
{

    /**
     * @var
     */
    private $names;
    private $rounds;
    private $byes;
    private $brackets;

    /**
     * @return mixed
     */
    public function getBrackets()
    {
        return $this->brackets;
    }

    /**
     * @param $dateDebut
     * @param $DateFin
     * @return bool|object
     */
    public function generateBrackets($names, $rounds, $byes)
    {
        // Ici
        $teams = $names;


        $noRounds = ((is_numeric($rounds)) && ($rounds > 0)) ? $rounds : 1;

        //If there's an odd number of teams then add a null

        if (count($teams) % 2) $teams[] = null;

        $away = array_splice($teams, (count($teams) / 2));
        $home = $teams;

        $brackets = array();

        for ($round = 1; $round <= $noRounds; $round++) {

            for ($i = 1; $i < count($home) + count($away); $i++) {

                for ($j = 0; $j < count($home); $j++) {

                    //If byes should be included or not

                    if ($byes || (!$byes && !is_null($home[$j]) && !is_null($away[$j]))) {

                        $brackets[$round][$i][$j] = array($home[$j], $away[$j]);

                        //Reverse the brackets for each even round

                        if ($round % 2 == 0) $brackets[$round][$i][$j] = array_reverse($brackets[$round][$i][$j]);

                    }

                }

                //Move the brackets around for a unique pairing

                if (count($home) + count($away) - 1 > 2) {

                    $splice = array_splice($home, 1, 1);
                    $shift = array_shift($splice);
                    array_unshift($away, $shift);
                    array_push($home, array_pop($away));

                }

            }

        }

        $this->brackets = $brackets;

    }
}