<?php

namespace sws\Bundle\BackBundle\Services;


/**
 * Class CalculPointsJoueur
 * @package sws\Bundle\BackBundle\Services
 */
class CalculPointsJoueur
{

    /**
     * @var
     */
    private $pointsJoueur1;
    private $pointsJoueur2;


    /**
     * @return mixed
     */
    public function getPointsJoueur1()
    {
        return $this->pointsJoueur1;
    }

    /**
     * @return mixed
     */
    public function getPointsJoueur2()
    {
        return $this->pointsJoueur2;
    }


    /**
     * Cette fonction retour les points gagnés/perdus des deux joueurs en fonction des résultat de leur macth
     *
     * On part du principe que si ce service est appellé, c'est que le score est correct et validé !!!!!!!!
     *
     * Règle d'attribution des points
     *
     * Règles d'attribution des points par SET :
     *
     * En double : Par vixtoire Set achevé -> 3 points sinon -> 0 point
     * En simple :
     *
     *  Par victoire :
     *      Set achevé :
     *             Sur classement supérieur -> 20 pts (Bonus de 5 pts par classement)
     *             Sur classement identique -> 20 pts
     *             Sur classement inférieur :
     *                         -> 10 pts (pour 1 classement inférieur)
     *                         ->  5 pts (pour 2 classements inférieurs)
     *                         ->  0 pt  (pour +2 classements inférieurs)
     *
     *      Set inachevé :
     *             Sur classement supérieur -> 10 pts (pas de bonus)
     *             Sur classement identique -> 10 pts
     *             Sur classement inférieur -> 0 pt
     *
     *  Par égalité :
     *      Set inachevé : Tous les cas 0 pt
     *
     * Par défaite :
     *     Set achevé :
     *            Sur classement supérieur -> 0 pt
     *            Sur classement identique -> 20 pts
     *            Sur classement inférieur -> 20 pts (Malus de 5 pts par classement)
     *
     *     Set incachevé :
     *            Sur classement supérieur -> 0 pt
     *            Sur classement identique -> 10 pts
     *            Sur classement inférieur -> 10 pts
     *
     *
     * @param $typeMatch
     * @param $classJoueur1
     * @param $classJoueur2
     * @param $pointsMatchJoueur1
     * @param $pointsMatchJoueur2
     * @return bool
     */
    public function processPointsJoueur($typeMatch, $classJoueur1, $classJoueur2, $jeuxSet1Joueur1, $jeuxSet2Joueur1, $jeuxSet3Joueur1, $jeuxSet1Joueur2, $jeuxSet2Joueur2, $jeuxSet3Joueur2)
    {

        $this->pointsJoueur1 = 0;
        $this->pointsJoueur2 = 0;

        switch ($typeMatch){
            case 'S':

                // Gestion du set N°1
                if ($jeuxSet1Joueur1 > $jeuxSet1Joueur2){

                    if ($jeuxSet1Joueur1 == 7){

                        // Set gagné
                        $this->pointsJoueur1 = $this->calculPoints('V', $classJoueur1, $classJoueur2);
                        $this->pointsJoueur2 = $this->calculPoints('D', $classJoueur2, $classJoueur1);
                    }
                    elseif($jeuxSet1Joueur1 == 6 && $jeuxSet1Joueur2 <> 5){

                        // Set gagné
                        $this->pointsJoueur1 = $this->calculPoints('V', $classJoueur1, $classJoueur2);
                        $this->pointsJoueur2 = $this->calculPoints('D', $classJoueur2, $classJoueur1);
                    }
                    else{
                        // Set mené
                        $this->pointsJoueur1 = $this->calculPoints('MV', $classJoueur1, $classJoueur2);
                        $this->pointsJoueur2 = $this->calculPoints('MD', $classJoueur2, $classJoueur1);
                    }
                }
                elseif($jeuxSet1Joueur1 == $jeuxSet1Joueur2){

                    if ($jeuxSet1Joueur1 == 0){
                        $this->pointsJoueur1 = 0;
                        $this->pointsJoueur2 = 0;
                    }
                    else{
                        // Points à attribuer au 2 joueurs
                        $this->pointsJoueur1 = $this->calculPoints('E', $classJoueur1, $classJoueur2);
                        $this->pointsJoueur2 = $this->calculPoints('E', $classJoueur2, $classJoueur1);
                    }
                }
                else{

                    if ($jeuxSet1Joueur2 == 7){

                        // Set gagné
                        $this->pointsJoueur1 = $this->calculPoints('D', $classJoueur1, $classJoueur2);
                        $this->pointsJoueur2 = $this->calculPoints('V', $classJoueur2, $classJoueur1);
                    }
                    elseif($jeuxSet1Joueur2 == 6 && $jeuxSet1Joueur1 <> 5){

                        // Set gagné
                        $this->pointsJoueur1 = $this->calculPoints('D', $classJoueur1, $classJoueur2);
                        $this->pointsJoueur2 = $this->calculPoints('V', $classJoueur2, $classJoueur1);
                    }
                    else{
                        // Set mené
                        $this->pointsJoueur1 = $this->calculPoints('MD', $classJoueur1, $classJoueur2);
                        $this->pointsJoueur2 = $this->calculPoints('MV', $classJoueur2, $classJoueur1);
                    }

                }

                // Gestion du set N°2
                if ($jeuxSet2Joueur1 > $jeuxSet2Joueur2){

                    // Points à attribuer au joueur 1
                    if ($jeuxSet2Joueur1 == 7){

                        // Set gagné
                        $this->pointsJoueur1 = $this->pointsJoueur1 + $this->calculPoints('V', $classJoueur1, $classJoueur2);
                        $this->pointsJoueur2 = $this->pointsJoueur2 + $this->calculPoints('D', $classJoueur2, $classJoueur1);
                    }
                    elseif($jeuxSet2Joueur1 == 6 && $jeuxSet2Joueur2 <> 5){

                        // Set gagné
                        $this->pointsJoueur1 = $this->pointsJoueur1 + $this->calculPoints('V', $classJoueur1, $classJoueur2);
                        $this->pointsJoueur2 = $this->pointsJoueur2 + $this->calculPoints('D', $classJoueur2, $classJoueur1);
                    }
                    else{
                        // Set mené
                        $this->pointsJoueur1 = $this->pointsJoueur1 + $this->calculPoints('MV', $classJoueur1, $classJoueur2);
                        $this->pointsJoueur2 = $this->pointsJoueur2 + $this->calculPoints('MD', $classJoueur2, $classJoueur1);
                    }
                }
                elseif($jeuxSet2Joueur1 == $jeuxSet2Joueur2){

                    if ($jeuxSet2Joueur1 == 0){
                        $this->pointsJoueur1 = $this->pointsJoueur1 + 0;
                        $this->pointsJoueur2 = $this->pointsJoueur2 + 0;
                    }
                    else{
                        // Points à attribuer au 2 joueurs
                        $this->pointsJoueur1 = $this->pointsJoueur1 + $this->calculPoints('E', $classJoueur1, $classJoueur2);
                        $this->pointsJoueur2 = $this->pointsJoueur2 + $this->calculPoints('E', $classJoueur2, $classJoueur1);
                    }
                }
                else{

                    if ($jeuxSet2Joueur2 == 7){

                        // Set gagné
                        $this->pointsJoueur1 = $this->pointsJoueur1 + $this->calculPoints('D', $classJoueur1, $classJoueur2);
                        $this->pointsJoueur2 = $this->pointsJoueur2 + $this->calculPoints('V', $classJoueur2, $classJoueur1);
                    }
                    elseif($jeuxSet2Joueur2 == 6 && $jeuxSet2Joueur1 <> 5){

                        // Set gagné
                        $this->pointsJoueur1 = $this->pointsJoueur1 + $this->calculPoints('D', $classJoueur1, $classJoueur2);
                        $this->pointsJoueur2 = $this->pointsJoueur2 + $this->calculPoints('V', $classJoueur2, $classJoueur1);
                    }
                    else{
                        // Set mené
                        $this->pointsJoueur1 = $this->pointsJoueur1 + $this->calculPoints('MD', $classJoueur1, $classJoueur2);
                        $this->pointsJoueur2 = $this->pointsJoueur2 + $this->calculPoints('MV', $classJoueur2, $classJoueur1);
                    }

                }

                // Gestion du set N°3
                if ($jeuxSet3Joueur1 > $jeuxSet3Joueur2){

                    // Points à attribuer au joueur 1
                    if ($jeuxSet3Joueur1 == 7){

                        // Set gagné
                        $this->pointsJoueur1 = $this->pointsJoueur1 + $this->calculPoints('V', $classJoueur1, $classJoueur2);
                        $this->pointsJoueur2 = $this->pointsJoueur2 + $this->calculPoints('D', $classJoueur2, $classJoueur1);
                    }
                    elseif($jeuxSet3Joueur1 == 6 && $jeuxSet3Joueur2 <> 5){

                        // Set gagné
                        $this->pointsJoueur1 = $this->pointsJoueur1 + $this->calculPoints('V', $classJoueur1, $classJoueur2);
                        $this->pointsJoueur2 = $this->pointsJoueur2 + $this->calculPoints('D', $classJoueur2, $classJoueur1);
                    }
                    else{
                        // Set mené
                        $this->pointsJoueur1 = $this->pointsJoueur1 + $this->calculPoints('MV', $classJoueur1, $classJoueur2);
                        $this->pointsJoueur2 = $this->pointsJoueur2 + $this->calculPoints('MD', $classJoueur2, $classJoueur1);
                    }
                }
                elseif($jeuxSet3Joueur1 == $jeuxSet3Joueur2){

                    if ($jeuxSet3Joueur1 == 0){
                        $this->pointsJoueur1 = $this->pointsJoueur1 + 0;
                        $this->pointsJoueur2 = $this->pointsJoueur2 + 0;
                    }
                    else{
                        // Points à attribuer au 2 joueurs
                        $this->pointsJoueur1 = $this->pointsJoueur1 + $this->calculPoints('E', $classJoueur1, $classJoueur2);
                        $this->pointsJoueur2 = $this->pointsJoueur2 + $this->calculPoints('E', $classJoueur2, $classJoueur1);
                    }
                }
                else{

                    if ($jeuxSet3Joueur2 == 7){

                        // Set gagné
                        $this->pointsJoueur1 = $this->pointsJoueur1 + $this->calculPoints('D', $classJoueur1, $classJoueur2);
                        $this->pointsJoueur2 = $this->pointsJoueur2 + $this->calculPoints('V', $classJoueur2, $classJoueur1);
                    }
                    elseif($jeuxSet3Joueur2 == 6 && $jeuxSet3Joueur1 <> 5){

                        // Set gagné
                        $this->pointsJoueur1 = $this->pointsJoueur1 + $this->calculPoints('D', $classJoueur1, $classJoueur2);
                        $this->pointsJoueur2 = $this->pointsJoueur2 + $this->calculPoints('V', $classJoueur2, $classJoueur1);
                    }
                    else{
                        // Set mené
                        $this->pointsJoueur1 = $this->pointsJoueur1 + $this->calculPoints('MD', $classJoueur1, $classJoueur2);
                        $this->pointsJoueur2 = $this->pointsJoueur2 + $this->calculPoints('MV', $classJoueur2, $classJoueur1);
                    }

                }

                break;
            case 'D':

                // Gestion du set N°1
                if ($jeuxSet1Joueur1 > $jeuxSet1Joueur2){

                    if ($jeuxSet1Joueur1 == 7){

                        // Set gagné
                        $this->pointsJoueur1 = 3;
                        $this->pointsJoueur2 = 0;
                    }
                    elseif($jeuxSet1Joueur1 == 6 && $jeuxSet1Joueur2 <> 5){

                        // Set gagné
                        $this->pointsJoueur1 = 3;
                        $this->pointsJoueur2 = 0;
                    }
                    else{
                        // Set mené
                        $this->pointsJoueur1 = 0;
                        $this->pointsJoueur2 = 0;
                    }
                }
                elseif($jeuxSet1Joueur1 == $jeuxSet1Joueur2){

                    $this->pointsJoueur1 = 0;
                    $this->pointsJoueur2 = 0;
                }
                else{

                    if ($jeuxSet1Joueur2 == 7){

                        // Set gagné
                        $this->pointsJoueur1 = 0;
                        $this->pointsJoueur2 = 3;
                    }
                    elseif($jeuxSet1Joueur2 == 6 && $jeuxSet1Joueur2 <> 5){

                        // Set gagné
                        $this->pointsJoueur1 = 0;
                        $this->pointsJoueur2 = 3;
                    }
                    else{
                        // Set mené
                        $this->pointsJoueur1 = 0;
                        $this->pointsJoueur2 = 0;
                    }
                }

                // Gestion du set N°2
                if ($jeuxSet2Joueur1 > $jeuxSet2Joueur2){

                    if ($jeuxSet2Joueur1 == 7){

                        // Set gagné
                        $this->pointsJoueur1 = $this->pointsJoueur1 + 3;
                        $this->pointsJoueur2 = $this->pointsJoueur2 + 0;
                    }
                    elseif($jeuxSet2Joueur1 == 6 && $jeuxSet2Joueur2 <> 5){

                        // Set gagné
                        $this->pointsJoueur1 = $this->pointsJoueur1 + 3;
                        $this->pointsJoueur2 = $this->pointsJoueur2 + 0;
                    }
                    else{
                        // Set mené
                        $this->pointsJoueur1 = $this->pointsJoueur1 + 0;
                        $this->pointsJoueur2 = $this->pointsJoueur2 + 0;
                    }
                }
                elseif($jeuxSet2Joueur1 == $jeuxSet2Joueur2){

                    $this->pointsJoueur1 = $this->pointsJoueur1 + 0;
                    $this->pointsJoueur2 = $this->pointsJoueur2 + 0;
                }
                else{

                    if ($jeuxSet2Joueur2 == 7){

                        // Set gagné
                        $this->pointsJoueur1 = $this->pointsJoueur1 + 0;
                        $this->pointsJoueur2 = $this->pointsJoueur2 + 3;
                    }
                    elseif($jeuxSet2Joueur2 == 6 && $jeuxSet2Joueur2 <> 5){

                        // Set gagné
                        $this->pointsJoueur1 = $this->pointsJoueur1 + 0;
                        $this->pointsJoueur2 = $this->pointsJoueur2 + 3;
                    }
                    else{
                        // Set mené
                        $this->pointsJoueur1 = $this->pointsJoueur1 + 0;
                        $this->pointsJoueur2 = $this->pointsJoueur2 + 0;
                    }
                }

                // Gestion du set N°3
                if ($jeuxSet3Joueur1 > $jeuxSet3Joueur2){

                    if ($jeuxSet3Joueur1 == 7){

                        // Set gagné
                        $this->pointsJoueur1 = $this->pointsJoueur1 + 3;
                        $this->pointsJoueur2 = $this->pointsJoueur2 + 0;
                    }
                    elseif($jeuxSet3Joueur1 == 6 && $jeuxSet3Joueur2 <> 5){

                        // Set gagné
                        $this->pointsJoueur1 = $this->pointsJoueur1 + 3;
                        $this->pointsJoueur2 = $this->pointsJoueur2 + 0;
                    }
                    else{
                        // Set mené
                        $this->pointsJoueur1 = $this->pointsJoueur1 + 0;
                        $this->pointsJoueur2 = $this->pointsJoueur2 + 0;
                    }
                }
                elseif($jeuxSet3Joueur1 == $jeuxSet3Joueur2){

                    $this->pointsJoueur1 = $this->pointsJoueur1 + 0;
                    $this->pointsJoueur2 = $this->pointsJoueur2 + 0;
                }
                else{

                    if ($jeuxSet3Joueur2 == 7){

                        // Set gagné
                        $this->pointsJoueur1 = $this->pointsJoueur1 + 0;
                        $this->pointsJoueur2 = $this->pointsJoueur2 + 3;
                    }
                    elseif($jeuxSet3Joueur2 == 6 && $jeuxSet3Joueur2 <> 5){

                        // Set gagné
                        $this->pointsJoueur1 = $this->pointsJoueur1 + 0;
                        $this->pointsJoueur2 = $this->pointsJoueur2 + 3;
                    }
                    else{
                        // Set mené
                        $this->pointsJoueur1 = $this->pointsJoueur1 + 0;
                        $this->pointsJoueur2 = $this->pointsJoueur2 + 0;
                    }
                }
                

                break;
        }
    }

    /**
     * @param $type
     * V = Victoire
     * D = Défaite
     * E = Egalité
     * MV = Mené victoire
     * MD = Mené défaite
     *
     * @param $classementJoueur
     * @param $classementAdversaire
     * @return int
     */
    public function calculPoints($type, $classementJoueur, $classementAdversaire){

        $diffClassement = $classementJoueur - $classementAdversaire;

        // Si $diffclassement = 0 -> mêmes classements
        // Si $diffclassement > 0 -> le joueur est plus faible que son adversaire
        // Si $diffclassement < 0 -> le joueur est plus fort que son adversaire

        $bonusMalus = 5 * $diffClassement;

        switch ($type){
            case 'V':
                if ($diffClassement == 0){

                    // Même classement
                    $points = 20;

                }elseif ($diffClassement > 0){

                    // Classement du joueur inférieur à l'adversaire
                    $points = 20 + $bonusMalus;
                }else{

                    // Classement du joueur supérieur à l'adversaire
                    if ($diffClassement == -1){

                        $points = 10; // 1 classement supérieur
                    }elseif($diffClassement == -2){

                        $points = 5; // 2 classements supérieurs
                    }else{

                        $points = 0; // plus de 2 classements supérieurs
                    }
                }
                break;
            case 'MD':
                if ($diffClassement > 0){
                    $points = 0;
                }
                elseif ($diffClassement <= 0){
                    $points = -10;
                }
                break;
            case 'MV':
                if ($diffClassement >= 0){
                    $points = 10;
                }
                else{
                    $points = 0;
                }
                break;
            case 'E':
                $points = 0; // Set égalite -> toujours 0 points
                break;
            case 'D':
                if ($diffClassement > 0){
                    $points = 0;
                }elseif($diffClassement == 0){
                    $points = -20;
                }else{
                    $points = -20 + $bonusMalus;
                }
                break;
        }
        return $points;
    }
}