<?php

namespace sws\Bundle\BackBundle\Services;

/**
 * Class CalculClassementMixte
 *
 * Ce service clacul le classement mixte d'une joueuse (- 3 classements)
 * @package sws\Bundle\BackBundle\Services
 */
class CalculClassementMixte
{
    /**
     * @var
     */
    private $valeurMixteClassement;

    /**
     * @return mixed
     */
    public function getValeurMixteClassement()
    {
        return $this->valeurMixteClassement;
    }

    /**
     * Clacul le classement mixte d'une joueuse 
     *
     * Règles  :
     *
     * Le classement est diminué de 3 rangs (+ 3 numeroOrdre)
     *
     */
    public function processClassementMixte($numeroOrdreClassement)
    {
        $this->valeurMixteClassement = 0;
        $this->valeurMixteClassement = $numeroOrdreClassement + 5; // +3 car ordre numeroOrdre est inversé

        if ($this->valeurMixteClassement >= 24 ){

            $this->valeurMixteClassement = 23; // C30.5 et non pas NC (24)
        }
    }
}