<?php

namespace sws\Bundle\BackBundle\Services;


/**
 * Class CalculClassementJoueur
 * @package sws\Bundle\BackBundle\Services
 */
class CalculClassementJoueur
{

    /**
     * @var
     */
    private $valeurClassement;

    /**
     * @return mixed
     */
    public function getValeurClassement()
    {
        return $this->valeurClassement;
    }


    /**
     * Cette fonction retourne le nouveau classement d'un joueur
     *
     *
     * Règles  :
     *
     * Par tranche de +100 pts -> 5 pts de classement supplémentaire (1 classement suppl.)
     * Par tranche de -100 pts -> 5 pts de classement inférieur (1 classement inférieur.)
     * En simple :
     *
     * @param $typeMatch
     * @param $classJoueur1
     * @param $classJoueur2
     * @param $pointsMatchJoueur1
     * @param $pointsMatchJoueur2
     * @return bool
     */
    public function processClassementJoueur($valeurClassementOld, $pointsJoueur)
    {
        $this->valeurClassement = 0;

        $bonusMalus = (int)($pointsJoueur / 100);
        $this->valeurClassement = $valeurClassementOld + ($bonusMalus * 5);
        if ($valeurClassementOld == 3){
            $this->valeurClassement = $this->valeurClassement - 3; // Pour eviter les erreur de calcul suite multiple de 5
        }
        if ($this->valeurClassement < 3){
            $this->valeurClassement = 3;
        }
        
    }
}