<?php

/*
 * This file is part of the FOSUserBundle package.
 *
 * (c) FriendsOfSymfony <http://friendsofsymfony.github.com/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace sws\Bundle\BackBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class UserModifyType extends AbstractType
{

    public function __construct($options = null) {
        $this->options = $options;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $opts = $this->options;

        $builder
            ->add('path')
            ->add('file','file',array('required' => false))
            ->add('email', 'email', array('label' => 'form.email', 'translation_domain' => 'FOSUserBundle'))
            ->add('username', null, array('label' => 'form.username', 'translation_domain' => 'FOSUserBundle'))
            ->add('nom')
            ->add('prenom')
            ->add('roles', 'collection', array(
                    'type' => 'choice',
                    'options' => array(
                        'label' => false, /* Ajoutez cette ligne */
                        'choices' => array(
                            'ROLE_ADMIN' => 'Administrateur',
                            'ROLE_DELEGUE' => 'Délégué',
                            'ROLE_CAPITAINE' => 'Capitaine'
                        ),
                        'multiple' => false
                    )
                )
            )
            ->add('deletePhoto','checkbox', array('mapped' => false, 'required' => false))
        ;
    }

    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'sws\Bundle\BackBundle\Entity\User'
        ));

    }

    public function getName()
    {
        return 'User_form';
    }
}
