<?php

namespace sws\Bundle\BackBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;


class JoueursType extends AbstractType
{

	public function buildForm(FormBuilderInterface $builder, array $options)
	{
		$builder
            ->add('nom')		
            ->add('prenom')
            ->add('rue',null, array('required' => false))
            ->add('sexe', 'choice', array(
                'choices'   => array('F' => 'Féminin', 'M' => 'Masculin'),
                'empty_value' => 'Veuillez faire un choix',))
            ->add('numRue',null, array('required' => false))
            ->add('boiteNumero',null, array('required' => false))
            ->add('codePostal',null, array('required' => false))
            ->add('commune',null, array('required' => false))
            ->add('telPrive',null, array('required' => false))
            ->add('gsmPrive',null, array('required' => false))
            ->add('faxPrive',null, array('required' => false))
            ->add('emailPrive',null, array('required' => false))
            ->add('telPro',null, array('required' => false))
            ->add('gsmPro',null, array('required' => false))
            ->add('faxPro',null, array('required' => false))
            ->add('emailPro',null, array('required' => false))
            ->add('dateNaissance','date',array('widget' => 'single_text','format' => 'dd/MM/yyyy','required' => false))
            ->add('numAft',null, array('required' => false))
            ->add('numClubAft','integer', array('required' => false))
            ->add('numRil',null, array('required' => false))
            ->add('status','checkbox', array('required' => false))
            ->add('ghost','checkbox', array('required' => false))
            //->add('createdAt',null,array('attr'=>array('style'=>'display:none;')))
            //->add('updatedAt',null,array('attr'=>array('style'=>'display:none;')))
            ->add('submit','submit')
        ;

	}

	public function setDefaultOptions(OptionsResolverInterface $resolver)
	{
		$resolver->setDefaults(array(
			'data_class' => 'sws\Bundle\BackBundle\Entity\Joueurs'
			));

	}

	public function getName()
	{
		return 'joueurs_form';
	}
}