<?php

namespace sws\Bundle\BackBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use sws\Bundle\BackBundle\Entity\ChJoueurRepository;


class ChSimplesType extends AbstractType
{

    public function __construct($options = null) {
        $this->options = $options;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {

        $opts = $this->options;

        $builder
            ->add('jeuxSet1Eq1')
            ->add('jeuxSet1Eq2')
            ->add('jeuxSet2Eq1')
            ->add('jeuxSet2Eq2')
            ->add('jeuxSet3Eq1')
            ->add('jeuxSet3Eq2')
            ->add('pointsEquipe1')
            ->add('pointsEquipe2')

            ->add('joueur_Eq1Id', 'entity', array(
                'class' => 'swsBackBundle:ChJoueur',
                'property' => 'JoueurId.nom',
                'empty_value' => 'Choisissez un joueur',
                'query_builder' => function(ChJoueurRepository $er )  use ($opts) {
                     return $er->createQueryBuilder('c')
                        ->where('c.championnat_id = :idChampionnat')
                        ->setParameter('idChampionnat', $opts['idChampionnat'])
                        ->andWhere('c.chcorporation_id = :idCorporation1Ch')
                        ->setParameter('idCorporation1Ch', $opts['idCorporation1Ch'])
                        ->join('c.joueur_id', 'j')
                        ->addselect('j')
                        ->orderBy('c.id', 'ASC' );                        
                }
            ))
           
            ->add('createdAt', null, array('attr'=>array('style'=>'display:none;')))
            ->add('updatedAt', null, array('attr'=>array('style'=>'display:none;')))
            ->add('submit','submit')
        ;

    }

    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'sws\Bundle\BackBundle\Entity\ChSimples'
        ));

    }

    public function getName()
    {
        return 'ChSimples_form';
    }

}