<?php

namespace sws\Bundle\BackBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use sws\Bundle\BackBundle\Entity\ChPlanningRepository;


class ChRencontreRejectSlotType extends AbstractType
{

    public function __construct($options = null) {
        $this->options = $options;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {

        $opts = $this->options;

        $builder
            ->add('dateRencontre','entity', array(
                'class' => 'swsBackBundle:ChPlanning',
                'property' => 'dateRencontre',
                'empty_value' => 'Choisissez un nouveau slot',
                'query_builder' => function(ChPlanningRepository $er )  use ($opts) {
                    return $er->createQueryBuilder('p')
                        ->addSelect('p.dateRencontre')
                        ->where('p.championnat_id = :idChampionnat')
                        ->setParameter('idChampionnat', $opts['idChampionnat'])
                        ->andWhere('p.status = \'-\'')
                        ->orderBy('p.dateRencontre', 'ASC' );
                },
                'format' => 'dd/MM/yyyy',
                'mapped' => false
            ))
            ->add('createdAt', null, array('attr'=>array('style'=>'display:none;')))
            ->add('updatedAt', null, array('attr'=>array('style'=>'display:none;')))
            ->add('submit','submit')
        ;
    }

    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'sws\Bundle\BackBundle\Entity\ChRencontreReject'
        ));
    }

    public function getName()
    {
        return 'ChRencontreReject_form';
    }

}