<?php

namespace sws\Bundle\BackBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use sws\Bundle\BackBundle\Entity\ChampionnatRepository;

class ChParametresType extends AbstractType
{

    public function __construct($options = null) {
        $this->options = $options;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {

        $opts = $this->options;

        $builder
            ->add('pointSetGagne')
            ->add('pointSetLeader')
            ->add('pointEgalite')
            ->add('pointPerdu')
            ->add('nbJourMin')
            ->add('nbJourRetard')
            ->add('nbSetMax')
            ->add('contrainteExclude', 'choice', array(
                'choices'   => array('1' => 'Oui', '0' => 'Non'),
                'empty_value' => 'Veuillez faire un choix'))
            ->add('contrainteInclude', 'choice', array(
                'choices'   => array('1' => 'Oui', '0' => 'Non'),
                'empty_value' => 'Veuillez faire un choix'))
            ->add('contrainteJour', 'choice', array(
                'choices'   => array('1' => 'Oui', '0' => 'Non'),
                'empty_value' => 'Veuillez faire un choix'))
            ->add('contrainteSalle', 'choice', array(
                'choices'   => array('1' => 'Oui', '0' => 'Non'),
                'empty_value' => 'Veuillez faire un choix'))
            ->add('confirmed', 'choice', array(
                'choices'   => array('O' => 'Oui', 'N' => 'Non'),
                'empty_value' => 'Veuillez faire un choix',
                'required' => false))

             ->add('championnatHeritId', 'entity', array(
                'class' => 'swsBackBundle:Championnat',
                'property' => 'nom',
                'empty_value' => 'Choisissez un championnat',
                'query_builder' => function(ChampionnatRepository $er )  use ($opts) {
                     return $er->createQueryBuilder('c')
                        ->where('c.id <> :idChampionnat')
                        ->setParameter('idChampionnat', $opts['idChampionnat'])
                        ->orderBy('c.id', 'DESC' );                        
                }
            ))


            ->add('createdAt',null,array('attr'=>array('style'=>'display:none;')))
            ->add('updatedAt',null,array('attr'=>array('style'=>'display:none;')))
            ->add('submit','submit')
        ;

    }

    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'sws\Bundle\BackBundle\Entity\ChParametres'
        ));

    }

    public function getName()
    {
        return 'ChParametres_form';
    }

}