<?php

namespace sws\Bundle\BackBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;


class ChLocationType extends AbstractType
{

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('nom')
            ->add('jour', 'choice', array(
                'choices'   => array('1' => 'Lundi', '2' => 'Mardi', '3' => 'Mercredi', '4' => 'Jeudi', '5' => 'Vendredi', '6' => 'Samedi', '7' => 'Dimanche'),
                 'empty_value' => 'Choisissez un jour',)
            )
            ->add('tarifHeure') 
            ->add('heureDebut','time')
            ->add('heureFin','time')
            ->add('numeroRencontre', 'choice', array(
                'choices'   => array('1' => 'Rencontre #1', '2' => 'Rencontre #2', '3' => 'Rencontre #3', '4' => 'Rencontre #4', '5' => 'Rencontre #5', '6' => 'Rencontre #6', '7' => 'Rencontre #7'),
                 'empty_value' => 'Choisissez une option',)
            )
            
            ->add('typeSurfaceId', 'entity', array('class' => 'swsBackBundle:TypeSurface','property' => 'type', 'empty_value' => 'Choisissez une surface'))

            ->add('submit','submit')
        ;

    }

    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'sws\Bundle\BackBundle\Entity\ChLocation'
        ));

    }

    public function getName()
    {
        return 'ChLocation_form';
    }
}