<?php

namespace sws\Bundle\BackBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use sws\Bundle\BackBundle\Entity\ChClassementRepository;
use sws\Bundle\BackBundle\Entity\ChEquipeRepository;


class ChJoueurType extends AbstractType
{

    public function __construct($options = null) {
        $this->options = $options;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {

        $opts = $this->options;

        $builder
            ->add('delegue','checkbox', array('required' => false))
            ->add('desactive','checkbox', array('required' => false))
            ->add('remarque','textarea', array('required' => false))
            ->add('ChclassementReduId','entity', array(
                'class' => 'swsBackBundle:ChClassement',
                'property' => 'classement',
                'empty_value' => 'Choisissez un classement',
                'query_builder' => function(ChClassementRepository $er )  use ($opts) {
                    return $er->createQueryBuilder('c')
                        ->where('c.championnat_id = :idChampionnat')
                        ->setParameter('idChampionnat', $opts['idChampionnat'])
                        ->orderBy('c.numeroOrdre', 'ASC' );
                },
                'disabled' => true,
                'empty_value' => 'Classement inconnu'
            ))
            ->add('ChclassementRilPrecedentId', 'entity', array(
                'class' => 'swsBackBundle:ChClassement',
                'property' => 'classement',
                'empty_value' => 'Choisissez un classement',
                'query_builder' => function(ChClassementRepository $er )  use ($opts) {
                    return $er->createQueryBuilder('c')
                        ->where('c.championnat_id = :idChampionnat')
                        ->setParameter('idChampionnat', $opts['idChampionnat'])
                        ->orderBy('c.numeroOrdre', 'ASC' );
                },
                'disabled' => true,
                'empty_value' => 'Classement inconnu'
            ))
            ->add('ChclassementRilCalculId', 'entity', array(
                'class' => 'swsBackBundle:ChClassement',
                'property' => 'classement',
                'empty_value' => 'Choisissez un classement',
                'query_builder' => function(ChClassementRepository $er )  use ($opts) {
                    return $er->createQueryBuilder('c')
                        ->where('c.championnat_id = :idChampionnat')
                        ->setParameter('idChampionnat', $opts['idChampionnat'])
                        ->orderBy('c.numeroOrdre', 'ASC' );
                },
                'disabled' => true
            ))
            ->add('ChclassementRilMixteCalculId','entity', array(
                'class' => 'swsBackBundle:ChClassement',
                'property' => 'classement',
                'empty_value' => 'Choisissez un classement',
                'query_builder' => function(ChClassementRepository $er )  use ($opts) {
                    return $er->createQueryBuilder('c')
                        ->where('c.championnat_id = :idChampionnat')
                        ->setParameter('idChampionnat', $opts['idChampionnat'])
                        ->orderBy('c.numeroOrdre', 'ASC' );
                },
                'disabled' => true
            ))
            ->add('ChclassementRilMixteId', 'entity', array(
                'class' => 'swsBackBundle:ChClassement',
                'property' => 'classement',
                'empty_value' => 'Choisissez un classement',
                'query_builder' => function(ChClassementRepository $er )  use ($opts) {
                    return $er->createQueryBuilder('c')
                        ->where('c.championnat_id = :idChampionnat')
                        ->setParameter('idChampionnat', $opts['idChampionnat'])
                        ->orderBy('c.numeroOrdre', 'ASC' );
                }
            ))
            ->add('ChclassementRilId', 'entity', array(
                'class' => 'swsBackBundle:ChClassement',
                'property' => 'classement',
                'empty_value' => 'Choisissez un classement',
                'query_builder' => function(ChClassementRepository $er )  use ($opts) {
                     return $er->createQueryBuilder('c')
                        ->where('c.championnat_id = :idChampionnat')
                        ->setParameter('idChampionnat', $opts['idChampionnat'])
                        ->orderBy('c.numeroOrdre', 'ASC' );
                }
            ))
            ->add('ChequipecapitaineId', 'entity', array(
                'class' => 'swsBackBundle:ChEquipe',
                'property' => 'NomComplet',
                'empty_value' => 'Aucune équipe',
                'query_builder' => function(ChEquipeRepository $er )  use ($opts) {
                    return $er->createQueryBuilder('c')
                        ->where('c.chcorporation_id = :idChCorporation')
                        ->setParameter('idChCorporation', $opts['idChCorporation']);
                },
                'required' => false
            ))

            ->add('submit','submit')
        ;

    }

    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'sws\Bundle\BackBundle\Entity\ChJoueur'
        ));

    }

    public function getName()
    {
        return 'ChJoueur_form';
    }

}