<?php

namespace sws\Bundle\BackBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;


class ChIndisponibiliteJourFerieType extends AbstractType
{

    public function __construct($options = null) {
        $this->options = $options;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {

        $opts = $this->options;

        $builder
             ->add('type','text', array('data' => 'Jour férié', 'read_only' => true))
            ->add('typeCode','text', array('data' => '1', 'read_only' => true))
            ->add('libelle','text')

             ->add('fonction','choice',array('choices' =>array('E' => 'Exclusion'),'empty_value' => 'Choisissez une option'))
            ->add('periodeDebut','date',array('widget' => 'single_text','format' => 'dd/MM/yyyy','required' => false))
            ->add('periodeFin','date',array('widget' => 'single_text','format' => 'dd/MM/yyyy','required' => false))

            ->add('submit','submit')
        ;

    }

    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'sws\Bundle\BackBundle\Entity\ChIndisponibilite'
        ));

    }

    public function getName()
    {
        return 'ChIndisponibiliteJourFerie_form';
    }

}