<?php

namespace sws\Bundle\BackBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use sws\Bundle\BackBundle\Entity\ChClassementRepository;


class ChEquipeType extends AbstractType
{

    public function __construct($options = null) {
        $this->options = $options;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {

        $opts = $this->options;

        $builder
            ->add('nom')
            ->add('numeroEquipe')
            ->add('suffixEquipe')
            ->add('ptsMaximum')
            ->add('ptsMinimum')
            ->add('genre', 'choice', array(
                'choices'   => array('F' => 'Féminin', 'M' => 'Masculin', 'X' => 'Mixte'),
                'empty_value' => 'Choisissez un genre',))

            ->add('submit','submit')
        ;

    }

    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'sws\Bundle\BackBundle\Entity\ChEquipe'
        ));

    }

    public function getName()
    {
        return 'ChEquipe_form';
    }

}