<?php

namespace sws\Bundle\BackBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;


class ChDivisionType extends AbstractType
{

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        	->add('nom')
        	->add('numero')
        	->add('suffixe')
            ->add('color')
            ->add('textColor')
        	->add('ptsMinimum')
        	->add('ptsMaximum')
            ->add('nbTours')
            ->add('genre', 'choice', array(
                'choices'   => array('F' => 'Féminin', 'M' => 'Masculin', 'X' => 'Mixte'),
                'empty_value' => 'Choisissez un genre',))

            ->add('submit','submit')
        ;

    }

    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'sws\Bundle\BackBundle\Entity\ChDivision'
        ));

    }

    public function getName()
    {
        return 'ChDivision_form';
    }
}