<?php

namespace sws\Bundle\BackBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use sws\Bundle\BackBundle\Entity\ChSalleRepository;


class ChContrainteSalleType extends AbstractType
{

    public function __construct($options = null) {
        $this->options = $options;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {

        $opts = $this->options;

        $builder
             ->add('type','text', array('data' => 'Salle', 'read_only' => true))
             ->add('typeCode','text', array('data' => '2', 'read_only' => true))
             ->add('fonction','choice',array('choices' =>array('E' => 'Exclusion', 'I' => 'Inclusion'),'empty_value' => 'Choisissez une option'))
             ->add('priorite')
             ->add('ChSalleId', 'entity', array(
                'class' => 'swsBackBundle:ChSalle',
                'property' => 'SalleId.nom',
                'empty_value' => 'Choisissez une salle',
                'query_builder' => function(ChSalleRepository $er )  use ($opts) {
                     return $er->createQueryBuilder('c')
                        ->where('c.championnat_id = :idChampionnat')
                        ->setParameter('idChampionnat', $opts['idChampionnat'])
                        ->join('c.salle_id', 's')
                        ->addselect('s')
                        ->orderBy('c.id', 'ASC' );                        
                }
            ))

            ->add('submit','submit')
        ;

    }

    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'sws\Bundle\BackBundle\Entity\ChContrainte'
        ));

    }

    public function getName()
    {
        return 'ChContrainteSalle_form';
    }

}