<?php

namespace sws\Bundle\BackBundle\Entity;

use ED\BlogBundle\Interfaces\Repository\BlogUserRepositoryInterface;
use ED\BlogBundle\Model\Repository\UserRepository as BaseUserRepository;
use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Tools\Pagination\Paginator;

/**
 * UserRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class UserRepository extends BaseUserRepository implements BlogUserRepositoryInterface
{

    public function getUsers($page, $nbPerPage)
    {
        $query = $this->createQueryBuilder('u')
            ->orderBy('u.enabled', 'DESC')
            ->addOrderBy('u.nom', 'ASC')
            ->getQuery()
        ;

        $query
            // On définit l'annonce à partir de laquelle commencer la liste
            ->setFirstResult(($page-1) * $nbPerPage)
            // Ainsi que le nombre d'annonce à afficher sur une page
            ->setMaxResults($nbPerPage)
        ;

        return new Paginator($query, true);
    }

    public function getUsersByCritere($critere, $page, $nbPerPage)
    {
        $query = $this->createQueryBuilder('u');

        $query
            ->where('u.nom like :critere')
            ->setParameter('critere', '%'.$critere.'%')
            ->orWhere('u.prenom like :critere')
            ->setParameter('critere', '%'.$critere.'%')
            ->orderBy('u.enabled', 'DESC')
            ->addOrderBy('u.nom', 'ASC')
            // On définit l'annonce à partir de laquelle commencer la liste
            ->setFirstResult(($page-1) * $nbPerPage)
            // Ainsi que le nombre d'annonce à afficher sur une page
            ->setMaxResults($nbPerPage)
        ;

        return new Paginator($query, true);
    }
}
