<?php

namespace sws\Bundle\BackBundle\Entity;


use ED\BlogBundle\Interfaces\Model\BlogUserInterface;
use ED\BlogBundle\Interfaces\Model\ArticleCommenterInterface;
use FOS\UserBundle\Model\User as BaseUser;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\Table(name="fos_user")
 * @ORM\Entity(repositoryClass="sws\Bundle\BackBundle\Entity\UserRepository")
 *
 * Class User
 * @package sws\Bundle\BackBundle\Entity
 */

class User extends BaseUser implements BlogUserInterface, ArticleCommenterInterface
{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     * @var
     */
    protected $id;

    /**
     * @var string
     *
     * @ORM\Column(name="nom", type="string", length=255, nullable=true)
     */
    private $nom;

    /**
     * @var string
     *
     * @ORM\Column(name="prenom", type="string", length=255, nullable=true)
     */
    private $prenom;

    /**
     * @ORM\OneToMany(targetEntity="Joueurs", mappedBy="user")
     *
     */
    private $joueurs;

    /**
     * @ORM\OneToMany(targetEntity="Corporation", mappedBy="user")
     *
     */
    private $corporations;

    /**
     * @ORM\OneToMany(targetEntity="TypeCorpo", mappedBy="user")
     *
     */
    private $typeCorpos;  

    /**
     * @ORM\OneToMany(targetEntity="Salle", mappedBy="user")
     *
     */
    private $salles;

    /**
     * @ORM\OneToMany(targetEntity="Championnat", mappedBy="user")
     *
     */
    private $championnats;

    /**
     * @ORM\OneToMany(targetEntity="ChSalle", mappedBy="user")
     *
     */
    private $chSalles;

    /**
     * @ORM\OneToMany(targetEntity="ChLocation", mappedBy="user")
     *
     */
    private $chlocations;

    /**
     * @Assert\File(maxSize="100000")
     */
    public $file;

    /**
     * @var string
     *
     * @ORM\Column(name="path", type="string", length=255, nullable=true)
     */
    private $path;

    /**
     * @return string
     */
    public function getPath()
    {
        return $this->path;
    }

    /**
     * @param string $path
     */
    public function setPath($path)
    {
        $this->path = $path;
    }

    public function getAbsolutePath()
    {
        return null === $this->path ? null : $this->getUploadRootDir().'/'.$this->path;
    }

    public function getWebPath()
    {
        return null === $this->path ? null : $this->getUploadDir().'/'.$this->path;
    }

    protected function getUploadRootDir()
    {
        // le chemin absolu du répertoire où les documents uploadés doivent être sauvegardés
        return __DIR__.'/../../../../../web/bundles/swsback/'.$this->getUploadDir();
    }

    protected function getUploadDir()
    {
        // on se débarrasse de « __DIR__ » afin de ne pas avoir de problème lorsqu'on affiche
        // le document/image dans la vue.
        return 'images/photoUser/';
    }

    /**
     * @return string
     */
    public function getPrenom()
    {
        return $this->prenom;
    }

    /**
     * @param string $prenom
     */
    public function setPrenom($prenom)
    {
        $this->prenom = $prenom;
    }


    /**
     * @return mixed
     */
    public function getChlocations()
    {
        return $this->chlocations;
    }

    /**
     * @return mixed
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * @param mixed $nom
     */
    public function setNom($nom)
    {
        $this->nom = $nom;
    }

    /**
     * @param mixed $chlocations
     */
    public function setChlocations($chlocations)
    {
        $this->chlocations = $chlocations;
    }

     /**
     * @return mixed
     */
    public function getChSalles()
    {
        return $this->chSalles;
    }

    /**
     * @param mixed $chSalles
     */
    public function setChSalles($chSalles)
    {
        $this->chSalles = $chSalles;
    }

    /**
     * @return mixed
     */
    public function getSalles()
    {
        return $this->salles;
    }

    /**
     * @param mixed $salles
     */
    public function setSalles($salles)
    {
        $this->salles = $salles;
    }

    /**
     * @return mixed
     */
    public function getChampionnats()
    {
        return $this->championnats;
    }

    /**
     * @param mixed $championnats
     */
    public function setChampionnats($championnats)
    {
        $this->championnats = $championnats;
    }

    public function __construct(){

        parent::__construct();
    }


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Add joueurs
     *
     * @param \sws\Bundle\BackBundle\Entity\Joueurs $joueurs
     * @return User
     */
    public function addJoueur(\sws\Bundle\BackBundle\Entity\Joueurs $joueurs)
    {
        $this->joueurs[] = $joueurs;

        return $this;
    }

    /**
     * Remove joueurs
     *
     * @param \sws\Bundle\BackBundle\Entity\Joueurs $joueurs
     */
    public function removeJoueur(\sws\Bundle\BackBundle\Entity\Joueurs $joueurs)
    {
        $this->joueurs->removeElement($joueurs);
    }

    /**
     * Get joueurs
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getJoueurs()
    {
        return $this->joueurs;
    }

    /**
     * Add corporations
     *
     * @param \sws\Bundle\BackBundle\Entity\Corporation $corporations
     * @return User
     */
    public function addCorporation(\sws\Bundle\BackBundle\Entity\Corporation $corporations)
    {
        $this->corporations[] = $corporations;

        return $this;
    }

    /**
     * Remove corporations
     *
     * @param \sws\Bundle\BackBundle\Entity\Corporation $corporations
     */
    public function removeCorporation(\sws\Bundle\BackBundle\Entity\Corporation $corporations)
    {
        $this->corporations->removeElement($corporations);
    }

    /**
     * Get corporations
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCorporations()
    {
        return $this->corporations;
    }

    /**
     * Add typeCorpos
     *
     * @param \sws\Bundle\BackBundle\Entity\TypeCorpo $typeCorpos
     * @return User
     */
    public function addTypeCorpo(\sws\Bundle\BackBundle\Entity\TypeCorpo $typeCorpos)
    {
        $this->typeCorpos[] = $typeCorpos;

        return $this;
    }

    /**
     * Remove typeCorpos
     *
     * @param \sws\Bundle\BackBundle\Entity\TypeCorpo $typeCorpos
     */
    public function removeTypeCorpo(\sws\Bundle\BackBundle\Entity\TypeCorpo $typeCorpos)
    {
        $this->typeCorpos->removeElement($typeCorpos);
    }

    /**
     * Get typeCorpos
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getTypeCorpos()
    {
        return $this->typeCorpos;
    }

    /**
     * Add salles
     *
     * @param \sws\Bundle\BackBundle\Entity\Salle $salles
     * @return User
     */
    public function addSalle(\sws\Bundle\BackBundle\Entity\Salle $salles)
    {
        $this->salles[] = $salles;

        return $this;
    }

    /**
     * Remove salles
     *
     * @param \sws\Bundle\BackBundle\Entity\Salle $salles
     */
    public function removeSalle(\sws\Bundle\BackBundle\Entity\Salle $salles)
    {
        $this->salles->removeElement($salles);
    }

    /**
     * Add championnats
     *
     * @param \sws\Bundle\BackBundle\Entity\Championnat $championnats
     * @return User
     */
    public function addChampionnat(\sws\Bundle\BackBundle\Entity\Championnat $championnats)
    {
        $this->championnats[] = $championnats;

        return $this;
    }

    /**
     * Remove championnats
     *
     * @param \sws\Bundle\BackBundle\Entity\Championnat $championnats
     */
    public function removeChampionnat(\sws\Bundle\BackBundle\Entity\Championnat $championnats)
    {
        $this->championnats->removeElement($championnats);
    }

    /**
     * Add chSalles
     *
     * @param \sws\Bundle\BackBundle\Entity\ChSalle $chSalles
     * @return User
     */
    public function addChSalle(\sws\Bundle\BackBundle\Entity\ChSalle $chSalles)
    {
        $this->chSalles[] = $chSalles;

        return $this;
    }

    /**
     * Remove chSalles
     *
     * @param \sws\Bundle\BackBundle\Entity\ChSalle $chSalles
     */
    public function removeChSalle(\sws\Bundle\BackBundle\Entity\ChSalle $chSalles)
    {
        $this->chSalles->removeElement($chSalles);
    }

    /**
     * Add chlocations
     *
     * @param \sws\Bundle\BackBundle\Entity\ChLocation $chlocations
     * @return User
     */
    public function addChlocation(\sws\Bundle\BackBundle\Entity\ChLocation $chlocations)
    {
        $this->chlocations[] = $chlocations;

        return $this;
    }

    /**
     * Remove chlocations
     *
     * @param \sws\Bundle\BackBundle\Entity\ChLocation $chlocations
     */
    public function removeChlocation(\sws\Bundle\BackBundle\Entity\ChLocation $chlocations)
    {
        $this->chlocations->removeElement($chlocations);
    }

    public function upload()
    {
        // la propriété « file » peut être vide si le champ n'est pas requis
        if (null === $this->file) {
            $this->path = '/bundles/swsback/images/photoUser/noimage.png';
            return;
        }

        // utilisez le nom de fichier original ici mais
        // vous devriez « l'assainir » pour au moins éviter
        // quelconques problèmes de sécurité

        // la méthode « move » prend comme arguments le répertoire cible et
        // le nom de fichier cible où le fichier doit être déplacé
        $this->file->move($this->getUploadRootDir(), $this->file->getClientOriginalName());

        // définit la propriété « path » comme étant le nom de fichier où vous
        // avez stocké le fichier

        // sws-todo : Gerer l'obfuscation du nom de l'image
        $this->path = '/bundles/swsback/images/photoUser/'.$this->file->getClientOriginalName();

        // « nettoie » la propriété « file » comme vous n'en aurez plus besoin
        $this->file = null;
    }

    /**
     * Required by BlogUserInterface
     *
     * @ORM\Column(name="blog_display_name", type="string")
     */
    protected $blogDisplayName;

    public function getBlogDisplayName()
    {
        return $this->blogDisplayName;
    }

    public function setBlogDisplayName($blogDisplayName)
    {
        $this->blogDisplayName = $blogDisplayName;

        return $this;
    }

    public function getCommenterDisplayName()
    {
        return $this->blogDisplayName;
    }

}
