<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * typeCorpo
 *
 * @ORM\Table(name="TypeCorpo")
 * @ORM\Entity(repositoryClass="sws\Bundle\BackBundle\Entity\TypeCorpoRepository")
 */
class TypeCorpo
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="type", type="string", length=255)
     */
    private $type;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="createdAt", type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="updatedAt", type="datetime")
     */
    private $updatedAt;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="typeCorpos")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     */
    protected $user;    

    /**
     * @ORM\OneToMany(targetEntity="Corporation", mappedBy="typecorpo")
     *
     */
    protected $typeCorpos2;


    public function __construct()
    {
        $this->createdAt         = new \Datetime();
        $this->updatedAt         = new \Datetime();
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set type
     *
     * @param string $type
     * @return typeCorpo
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * Get type
     *
     * @return string 
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @return mixed
     */
    public function getTypeCorpos2()
    {
        return $this->typeCorpos2;
    }

    /**
     * @param mixed $typeCorpos2
     */
    public function setTypeCorpos2($typeCorpos2)
    {
        $this->typeCorpos2 = $typeCorpos2;
    }

    /**
     * Set createdAt
     *
     * @param \DateTime $createdAt
     * @return typeCorpo
     */
    public function setCreatedAt($createdAt)
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime 
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Set updatedAt
     *
     * @param \DateTime $updatedAt
     * @return typeCorpo
     */
    public function setUpdatedAt($updatedAt)
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    /**
     * Get updatedAt
     *
     * @return \DateTime 
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * Set user
     *
     * @param \sws\Bundle\BackBundle\Entity\User $user
     * @return TypeCorpo
     */
    public function setUser(\sws\Bundle\BackBundle\Entity\User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return \sws\Bundle\BackBundle\Entity\User 
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Add typeCorpos
     *
     * @param \sws\Bundle\BackBundle\Entity\Corporation $typeCorpos
     * @return TypeCorpo
     */
    public function addTypeCorpo(\sws\Bundle\BackBundle\Entity\Corporation $typeCorpos)
    {
        $this->typeCorpos[] = $typeCorpos;

        return $this;
    }

    /**
     * Remove typeCorpos
     *
     * @param \sws\Bundle\BackBundle\Entity\Corporation $typeCorpos
     */
    public function removeTypeCorpo(\sws\Bundle\BackBundle\Entity\Corporation $typeCorpos)
    {
        $this->typeCorpos->removeElement($typeCorpos);
    }



    /**
     * Add typeCorpos2
     *
     * @param \sws\Bundle\BackBundle\Entity\Corporation $typeCorpos2
     * @return TypeCorpo
     */
    public function addTypeCorpos2(\sws\Bundle\BackBundle\Entity\Corporation $typeCorpos2)
    {
        $this->typeCorpos2[] = $typeCorpos2;

        return $this;
    }

    /**
     * Remove typeCorpos2
     *
     * @param \sws\Bundle\BackBundle\Entity\Corporation $typeCorpos2
     */
    public function removeTypeCorpos2(\sws\Bundle\BackBundle\Entity\Corporation $typeCorpos2)
    {
        $this->typeCorpos2->removeElement($typeCorpos2);
    }
}
