<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Tools\Pagination\Paginator;

/**
 * SallesRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class SalleRepository extends EntityRepository
{
    public function getAll()
    {
        $qb = $this->createQueryBuilder('s');

        $query = $qb;
        /*
            ->where('j.nom = :nom')
            ->setParameter('nom', 'Bettonville');
        */
        $result = $qb->getQuery()->getArrayResult();
        return $result;
    }

    public function getSalles($page, $nbPerPage)
    {
        $query = $this->createQueryBuilder('s')
          ->orderBy('s.nom', 'ASC')
          ->getQuery()
        ;

        $query
          // On définit l'annonce à partir de laquelle commencer la liste
          ->setFirstResult(($page-1) * $nbPerPage)
          // Ainsi que le nombre d'annonce à afficher sur une page
          ->setMaxResults($nbPerPage)
        ;

        // Enfin, on retourne l'objet Paginator correspondant à la requête construite
        // (n'oubliez pas le use correspondant en début de fichier)
        return new Paginator($query, true);
    }

    public function getSallesByCritere($critere, $page, $nbPerPage)
    {
        $query = $this->createQueryBuilder('s');

        $query
          ->where('s.nom like :critere')
          ->setParameter('critere', '%'.$critere.'%')
          ->orderBy('s.nom', 'ASC')
          // On définit l'annonce à partir de laquelle commencer la liste
          ->setFirstResult(($page-1) * $nbPerPage)
          // Ainsi que le nombre d'annonce à afficher sur une page
          ->setMaxResults($nbPerPage)
        ;

        // Enfin, on retourne l'objet Paginator correspondant à la requête construite
        // (n'oubliez pas le use correspondant en début de fichier)
        return new Paginator($query, true);
    }

    public function getSallesCh($id)
    {

        $query = $this->_em->createQuery('SELECT s FROM swsBackBundle:Salle s WHERE s.status = 1 and s.id not in (SELECT IDENTITY(ch.salle_id) FROM swsBackBundle:ChSalle ch WHERE ch.championnat_id = :id) ');

        //SELECT * FROM salles t1 where t1.sallesId not in (select sallesId from chSalles t2 where t2.championnatId = "'.$idChampionnat.'") and t1.status = 1

        $query->setParameter('id', $id);

        $results = $query->getResult();

        return $results;

    }
}
