<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;

/**
 * Salle
 *
 * @ORM\Table(name="Salle")
 * @ORM\Entity(repositoryClass="sws\Bundle\BackBundle\Entity\SalleRepository")
 * @UniqueEntity(fields="nom", message="Cette salle semble déjà exister (Ce nom est déjà existant)")
 */
class Salle
{
    public function __construct()
    {
        $this->status            = true;
    }

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="nom", type="string", length=255)
     */
    private $nom;

    /**
     * @var string
     *
     * @ORM\Column(name="color", type="string", length=7, nullable=true)
     */
    private $color;

    /**
     * @var string
     *
     * @ORM\Column(name="textColor", type="string", length=7, nullable=true)
     */
    private $textColor;    

    /**
     * @var string
     *
     * @ORM\Column(name="rue", type="string", length=255, nullable=true)
     */
    private $rue;

    /**
     * @var integer
     *
     * @ORM\Column(name="numeroRue", type="integer", nullable=true)
     */
    private $numeroRue;

    /**
     * @var string
     *
     * @ORM\Column(name="boiteRue", type="string", length=5, nullable=true)
     */
    private $boiteRue;

    /**
     * @var integer
     *
     * @ORM\Column(name="codePostal", type="integer", nullable=true)
     */
    private $codePostal;

    /**
     * @var string
     *
     * @ORM\Column(name="commune", type="string", length=255, nullable=true)
     */
    private $commune;

    /**
     * @var string
     *
     * @ORM\Column(name="telephoneSalle", type="string", length=255, nullable=true)
     */
    private $telephoneSalle;

    /**
     * @var string
     *
     * @ORM\Column(name="gsmSalle", type="string", length=255, nullable=true)
     */
    private $gsmSalle;

    /**
     * @Assert\Email()
     * @var string
     *
     * @ORM\Column(name="emailSalle", type="string", length=255, nullable=true)
     */
    private $emailSalle;

    /**
     * @var string
     *
     * @ORM\Column(name="nomProprietaire", type="string", length=255, nullable=true)
     */
    private $nomProprietaire;

    /**
     * @var string
     *
     * @ORM\Column(name="prenomProprietaire", type="string", length=255, nullable=true)
     */
    private $prenomProprietaire;

    /**
     * @var string
     *
     * @ORM\Column(name="telephoneProprietaire", type="string", length=255, nullable=true)
     */
    private $telephoneProprietaire;

    /**
     * @var string
     *
     * @ORM\Column(name="gsmProprietaire", type="string", length=255, nullable=true)
     */
    private $gsmProprietaire;

    /**
     * @Assert\Email()
     * @var string
     *
     * @ORM\Column(name="emailProprietaire", type="string", length=255, nullable=true)
     */
    private $emailProprietaire;

    /**
     * @var string
     *
     * @ORM\Column(name="faxSalle", type="string", length=255, nullable=true)
     */
    private $faxSalle;

    /**
     * @var string
     *
     * @ORM\Column(name="faxProprietaire", type="string", length=255, nullable=true)
     */
    private $faxProprietaire;

    /**
     * @var string
     *
     * @ORM\Column(name="rueProprietaire", type="string", length=255, nullable=true)
     */
    private $rueProprietaire;

    /**
     * @var integer
     *
     * @ORM\Column(name="numeroRueProprietaire", type="integer", nullable=true)
     */
    private $numeroRueProprietaire;

    /**
     * @var string
     *
     * @ORM\Column(name="boiteRueProprietaire", type="string", length=5, nullable=true)
     */
    private $boiteRueProprietaire;

    /**
     * @var integer
     *
     * @ORM\Column(name="codePostalProprietaire", type="integer", nullable=true)
     */
    private $codePostalProprietaire;

    /**
     * @var string
     *
     * @ORM\Column(name="communeProprietaire", type="string", length=255, nullable=true)
     */
    private $communeProprietaire;

    /**
     * @var boolean
     *
     * @ORM\Column(name="status", type="boolean", nullable=true)
     */
    private $status;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="create")
     * @ORM\Column(name="createdAt", type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="update")
     * @ORM\Column(name="updatedAt", type="datetime")
     */
    private $updatedAt;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="salles")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     */
    protected $user;

    /**
     * @ORM\OneToMany(targetEntity="ChSalle", mappedBy="salle_id")
     *
     */
    private $salles;

    /**
     * @Gedmo\Slug(fields={"nom"})
     * @ORM\Column(length=128, unique=true)
     */

    private $slug;

    /**
     * @return mixed
     */
    public function getSlug()
    {
        return $this->slug;
    }

    /**
     * @return mixed
     */
    public function getSalles()
    {
        return $this->salles;
    }

    /**
     * @param mixed $salles
     */
    public function setSalles($salles)
    {
        $this->salles = $salles;
    }

    /**
     * @return mixed
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @param mixed $user
     */
    public function setUser($user)
    {
        $this->user = $user;
    }



    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nom
     *
     * @param string $nom
     * @return Salle
     */
    public function setNom($nom)
    {
        $this->nom = $nom;

        return $this;
    }

    /**
     * Get nom
     *
     * @return string 
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * Set rue
     *
     * @param string $rue
     * @return Salle
     */
    public function setRue($rue)
    {
        $this->rue = $rue;

        return $this;
    }

    /**
     * Get rue
     *
     * @return string 
     */
    public function getRue()
    {
        return $this->rue;
    }

    /**
     * Set numeroRue
     *
     * @param integer $numeroRue
     * @return Salle
     */
    public function setNumeroRue($numeroRue)
    {
        $this->numeroRue = $numeroRue;

        return $this;
    }

    /**
     * Get numeroRue
     *
     * @return integer 
     */
    public function getNumeroRue()
    {
        return $this->numeroRue;
    }

    /**
     * Set boiteRue
     *
     * @param string $boiteRue
     * @return Salle
     */
    public function setBoiteRue($boiteRue)
    {
        $this->boiteRue = $boiteRue;

        return $this;
    }

    /**
     * Get boiteRue
     *
     * @return string 
     */
    public function getBoiteRue()
    {
        return $this->boiteRue;
    }

    /**
     * Set codePostal
     *
     * @param integer $codePostal
     * @return Salle
     */
    public function setCodePostal($codePostal)
    {
        $this->codePostal = $codePostal;

        return $this;
    }

    /**
     * Get codePostal
     *
     * @return integer 
     */
    public function getCodePostal()
    {
        return $this->codePostal;
    }

    /**
     * Set commune
     *
     * @param string $commune
     * @return Salle
     */
    public function setCommune($commune)
    {
        $this->commune = $commune;

        return $this;
    }

    /**
     * Get commune
     *
     * @return string 
     */
    public function getCommune()
    {
        return $this->commune;
    }

    /**
     * Set telephoneSalle
     *
     * @param string $telephoneSalle
     * @return Salle
     */
    public function setTelephoneSalle($telephoneSalle)
    {
        $this->telephoneSalle = $telephoneSalle;

        return $this;
    }

    /**
     * Get telephoneSalle
     *
     * @return string 
     */
    public function getTelephoneSalle()
    {
        return $this->telephoneSalle;
    }

    /**
     * Set gsmSalle
     *
     * @param string $gsmSalle
     * @return Salle
     */
    public function setGsmSalle($gsmSalle)
    {
        $this->gsmSalle = $gsmSalle;

        return $this;
    }

    /**
     * Get gsmSalle
     *
     * @return string 
     */
    public function getGsmSalle()
    {
        return $this->gsmSalle;
    }

    /**
     * Set emailSalle
     *
     * @param string $emailSalle
     * @return Salle
     */
    public function setEmailSalle($emailSalle)
    {
        $this->emailSalle = $emailSalle;

        return $this;
    }

    /**
     * Get emailSalle
     *
     * @return string 
     */
    public function getEmailSalle()
    {
        return $this->emailSalle;
    }

    /**
     * Set nomProprietaire
     *
     * @param string $nomProprietaire
     * @return Salle
     */
    public function setNomProprietaire($nomProprietaire)
    {
        $this->nomProprietaire = $nomProprietaire;

        return $this;
    }

    /**
     * Get nomProprietaire
     *
     * @return string 
     */
    public function getNomProprietaire()
    {
        return $this->nomProprietaire;
    }

    /**
     * Set prenomProprietaire
     *
     * @param string $prenomProprietaire
     * @return Salle
     */
    public function setPrenomProprietaire($prenomProprietaire)
    {
        $this->prenomProprietaire = $prenomProprietaire;

        return $this;
    }

    /**
     * Get prenomProprietaire
     *
     * @return string 
     */
    public function getPrenomProprietaire()
    {
        return $this->prenomProprietaire;
    }

    /**
     * Set telephoneProprietaire
     *
     * @param string $telephoneProprietaire
     * @return Salle
     */
    public function setTelephoneProprietaire($telephoneProprietaire)
    {
        $this->telephoneProprietaire = $telephoneProprietaire;

        return $this;
    }

    /**
     * Get telephoneProprietaire
     *
     * @return string 
     */
    public function getTelephoneProprietaire()
    {
        return $this->telephoneProprietaire;
    }

    /**
     * Set gsmProprietaire
     *
     * @param string $gsmProprietaire
     * @return Salle
     */
    public function setGsmProprietaire($gsmProprietaire)
    {
        $this->gsmProprietaire = $gsmProprietaire;

        return $this;
    }

    /**
     * Get gsmProprietaire
     *
     * @return string 
     */
    public function getGsmProprietaire()
    {
        return $this->gsmProprietaire;
    }

    /**
     * Set emailProprietaire
     *
     * @param string $emailProprietaire
     * @return Salle
     */
    public function setEmailProprietaire($emailProprietaire)
    {
        $this->emailProprietaire = $emailProprietaire;

        return $this;
    }

    /**
     * Get emailProprietaire
     *
     * @return string 
     */
    public function getEmailProprietaire()
    {
        return $this->emailProprietaire;
    }

    /**
     * Set faxSalle
     *
     * @param string $faxSalle
     * @return Salle
     */
    public function setFaxSalle($faxSalle)
    {
        $this->faxSalle = $faxSalle;

        return $this;
    }

    /**
     * Get faxSalle
     *
     * @return string 
     */
    public function getFaxSalle()
    {
        return $this->faxSalle;
    }

    /**
     * Set faxProprietaire
     *
     * @param string $faxProprietaire
     * @return Salle
     */
    public function setFaxProprietaire($faxProprietaire)
    {
        $this->faxProprietaire = $faxProprietaire;

        return $this;
    }

    /**
     * Get faxProprietaire
     *
     * @return string 
     */
    public function getFaxProprietaire()
    {
        return $this->faxProprietaire;
    }

    /**
     * Set rueProprietaire
     *
     * @param string $rueProprietaire
     * @return Salle
     */
    public function setRueProprietaire($rueProprietaire)
    {
        $this->rueProprietaire = $rueProprietaire;

        return $this;
    }

    /**
     * Get rueProprietaire
     *
     * @return string 
     */
    public function getRueProprietaire()
    {
        return $this->rueProprietaire;
    }

    /**
     * Set numeroRueProprietaire
     *
     * @param integer $numeroRueProprietaire
     * @return Salle
     */
    public function setNumeroRueProprietaire($numeroRueProprietaire)
    {
        $this->numeroRueProprietaire = $numeroRueProprietaire;

        return $this;
    }

    /**
     * Get numeroRueProprietaire
     *
     * @return integer 
     */
    public function getNumeroRueProprietaire()
    {
        return $this->numeroRueProprietaire;
    }

    /**
     * Set boiteRuePoprietaire
     *
     * @param string $boiteRuePoprietaire
     * @return Salle
     */
    public function setBoiteRuePoprietaire($boiteRuePoprietaire)
    {
        $this->boiteRuePoprietaire = $boiteRuePoprietaire;

        return $this;
    }

    /**
     * Get boiteRuePoprietaire
     *
     * @return string 
     */
    public function getBoiteRuePoprietaire()
    {
        return $this->boiteRuePoprietaire;
    }

    /**
     * Set codePostalProprietaire
     *
     * @param integer $codePostalProprietaire
     * @return Salle
     */
    public function setCodePostalProprietaire($codePostalProprietaire)
    {
        $this->codePostalProprietaire = $codePostalProprietaire;

        return $this;
    }

    /**
     * Get codePostalProprietaire
     *
     * @return integer 
     */
    public function getCodePostalProprietaire()
    {
        return $this->codePostalProprietaire;
    }

    /**
     * Set communeProprietaire
     *
     * @param string $communeProprietaire
     * @return Salle
     */
    public function setCommuneProprietaire($communeProprietaire)
    {
        $this->communeProprietaire = $communeProprietaire;

        return $this;
    }

    /**
     * Get communeProprietaire
     *
     * @return string 
     */
    public function getCommuneProprietaire()
    {
        return $this->communeProprietaire;
    }

    /**
     * Set status
     *
     * @param boolean $status
     * @return Salle
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return boolean 
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime 
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Get updatedAt
     *
     * @return \DateTime 
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * Set boiteRueProprietaire
     *
     * @param string $boiteRueProprietaire
     * @return Salle
     */
    public function setBoiteRueProprietaire($boiteRueProprietaire)
    {
        $this->boiteRueProprietaire = $boiteRueProprietaire;

        return $this;
    }

    /**
     * Get boiteRueProprietaire
     *
     * @return string 
     */
    public function getBoiteRueProprietaire()
    {
        return $this->boiteRueProprietaire;
    }

    /**
     * Add salles
     *
     * @param \sws\Bundle\BackBundle\Entity\chSalle $salles
     * @return Salle
     */
    public function addSalle(\sws\Bundle\BackBundle\Entity\chSalle $salles)
    {
        $this->salles[] = $salles;

        return $this;
    }

    /**
     * Remove salles
     *
     * @param \sws\Bundle\BackBundle\Entity\chSalle $salles
     */
    public function removeSalle(\sws\Bundle\BackBundle\Entity\chSalle $salles)
    {
        $this->salles->removeElement($salles);
    }

    /**
     * Set color
     *
     * @param string $color
     * @return Salle
     */
    public function setColor($color)
    {
        $this->color = $color;

        return $this;
    }

    /**
     * Get color
     *
     * @return string 
     */
    public function getColor()
    {
        return $this->color;
    }

    /**
     * Set textColor
     *
     * @param string $textColor
     * @return Salle
     */
    public function setTextColor($textColor)
    {
        $this->textColor = $textColor;

        return $this;
    }

    /**
     * Get textColor
     *
     * @return string 
     */
    public function getTextColor()
    {
        return $this->textColor;
    }
}
