<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Tools\Pagination\Paginator;

/**
 * ReduRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ReduRepository extends EntityRepository
{

    public function getJoueursredu($page, $nbPerPage)
    {
        $query = $this->createQueryBuilder('j')
          ->orderBy('j.AFNUMERO', 'ASC')
          ->getQuery()
        ;

        $query
          // On définit l'annonce à partir de laquelle commencer la liste
          ->setFirstResult(($page-1) * $nbPerPage)
          // Ainsi que le nombre d'annonce à afficher sur une page
          ->setMaxResults($nbPerPage)
        ;

        // Enfin, on retourne l'objet Paginator correspondant à la requête construite
        // (n'oubliez pas le use correspondant en début de fichier)
        return new Paginator($query, true);
    }

    public function getJoueursReduByCritere($critere, $page, $nbPerPage)
    {
        $query = $this->createQueryBuilder('j');

        $query
          ->where('j.aFNOM like :critere')
          ->setParameter('critere', '%'.$critere.'%')
          ->orWhere('j.aFPRENOM like :critere')
          ->setParameter('critere', '%'.$critere.'%')
          ->orWhere('j.AFNUMERO like :critere')
          ->setParameter('critere', '%'.$critere.'%')          
          ->orderBy('j.AFNUMERO', 'ASC')
          // On définit l'annonce à partir de laquelle commencer la liste
          ->setFirstResult(($page-1) * $nbPerPage)
          // Ainsi que le nombre d'annonce à afficher sur une page
          ->setMaxResults($nbPerPage)
        ;

        // Enfin, on retourne l'objet Paginator correspondant à la requête construite
        // (n'oubliez pas le use correspondant en début de fichier)
        return new Paginator($query, true);
    }

    public function getJoueurReduArray($numAft)
    {
        $query = $this->createQueryBuilder('r')
            ->where('r.AFNUMERO = :numAft')
            ->setParameter('numAft', $numAft)
        ;

        $result = $query->getQuery()->getArrayResult();
        return $result;
    }

}
