<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Doctrine\ORM\Mapping\Index;

/**
 * Redu
 *
 * @ORM\Table(name="redu",indexes={@ORM\Index(name="noaft_idx", columns={"AF_NUMERO"})})
 * @ORM\Entity(repositoryClass="sws\Bundle\BackBundle\Entity\ReduRepository")
 */
class Redu
{

    /**
     * @var integer
     *
     * @ORM\Column(name="AF_NUMERO", type="integer")
     */
    private $AFNUMERO;

    /**
     * @var string
     *
     * @ORM\Column(name="AF_NOM", type="string", length=255)
     */
    private $aFNOM;

    /**
     * @var string
     *
     * @ORM\Column(name="AF_PRENOM", type="string", length=255)
     */
    private $aFPRENOM;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="AF_NAISSANCE", type="string", length=10)
     */
    private $aFNAISSANCE;

    /**
     * @var integer
     *
     * @ORM\Column(name="AF_CLUB1", type="integer")
     */
    private $aFCLUB1;

    /**
     * @var string
     *
     * @ORM\Column(name="AF_SEXE", type="string", length=1)
     */
    private $aFSEXE;

    /**
     * @var integer
     *
     * @ORM\Column(name="AF_NUMCLASS", type="integer")
     */
    private $aFNUMCLASS;

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @Assert\File(maxSize="6000000")
     */
    public $file;    

    /**
     * Sets file.
     *
     * @param UploadedFile $file
     */
    public function setFile(UploadedFile $file = null)
    {
        $this->file = $file;
    }

    /**
     * Get file.
     *
     * @return UploadedFile
     */
    public function getFile()
    {
        return $this->file;
    }
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return int
     */
    public function getAFNUMERO()
    {
        return $this->AFNUMERO;
    }

    /**
     * @param int $AFNUMERO
     */
    public function setAFNUMERO($AFNUMERO)
    {
        $this->AFNUMERO = $AFNUMERO;
    }

    /**
     * Set aFNOM
     *
     * @param string $aFNOM
     * @return Redu
     */
    public function setAFNOM($aFNOM)
    {
        $this->aFNOM = $aFNOM;

        return $this;
    }

    /**
     * Get aFNOM
     *
     * @return string 
     */
    public function getAFNOM()
    {
        return $this->aFNOM;
    }

    /**
     * Set aFPRENOM
     *
     * @param string $aFPRENOM
     * @return Redu
     */
    public function setAFPRENOM($aFPRENOM)
    {
        $this->aFPRENOM = $aFPRENOM;

        return $this;
    }

    /**
     * Get aFPRENOM
     *
     * @return string 
     */
    public function getAFPRENOM()
    {
        return $this->aFPRENOM;
    }

    /**
     * Set aFNAISSANCE
     *
     * @param \DateTime $aFNAISSANCE
     * @return Redu
     */
    public function setAFNAISSANCE($aFNAISSANCE)
    {
        $this->aFNAISSANCE = $aFNAISSANCE;

        return $this;
    }

    /**
     * Get aFNAISSANCE
     *
     * @return \DateTime 
     */
    public function getAFNAISSANCE()
    {
        return $this->aFNAISSANCE;
    }

    /**
     * Set aFCLUB1
     *
     * @param integer $aFCLUB1
     * @return Redu
     */
    public function setAFCLUB1($aFCLUB1)
    {
        $this->aFCLUB1 = $aFCLUB1;

        return $this;
    }

    /**
     * Get aFCLUB1
     *
     * @return integer 
     */
    public function getAFCLUB1()
    {
        return $this->aFCLUB1;
    }

    /**
     * Set aFSEXE
     *
     * @param string $aFSEXE
     * @return Redu
     */
    public function setAFSEXE($aFSEXE)
    {
        $this->aFSEXE = $aFSEXE;

        return $this;
    }

    /**
     * Get aFSEXE
     *
     * @return string 
     */
    public function getAFSEXE()
    {
        return $this->aFSEXE;
    }

    /**
     * Set aFNUMCLASS
     *
     * @param integer $aFNUMCLASS
     * @return Redu
     */
    public function setAFNUMCLASS($aFNUMCLASS)
    {
        $this->aFNUMCLASS = $aFNUMCLASS;

        return $this;
    }

    /**
     * Get aFNUMCLASS
     *
     * @return integer 
     */
    public function getAFNUMCLASS()
    {
        return $this->aFNUMCLASS;
    }

}
