<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Tools\Pagination\Paginator;

/**
 * JoueursRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class JoueursRepository extends EntityRepository
{
    public function getAll()
    {
        $qb = $this->createQueryBuilder('j');

        $query = $qb;
        /*
            ->where('j.nom = :nom')
            ->setParameter('nom', 'Bettonville');
        */
        $result = $qb->getQuery()->getArrayResult();

        return $result;
    }

    public function getJoueurs($page, $nbPerPage)
    {
        $query = $this->createQueryBuilder('j')
          ->orderBy('j.nom', 'ASC')
          ->getQuery()
        ;

        $query
          // On définit l'annonce à partir de laquelle commencer la liste
          ->setFirstResult(($page-1) * $nbPerPage)
          // Ainsi que le nombre d'annonce à afficher sur une page
          ->setMaxResults($nbPerPage)
        ;

        // Enfin, on retourne l'objet Paginator correspondant à la requête construite
        // (n'oubliez pas le use correspondant en début de fichier)
        return new Paginator($query, true);
    }

    public function getJoueursByCritere($critere, $page, $nbPerPage)
    {
        $query = $this->createQueryBuilder('j');

        $query
          ->where('j.nom like :critere')
          ->setParameter('critere', '%'.$critere.'%')
          ->orWhere('j.prenom like :critere')
          ->setParameter('critere', '%'.$critere.'%')
          ->orWhere('j.numAft like :critere')
          ->setParameter('critere', '%'.$critere.'%')          
          ->orderBy('j.nom', 'ASC')
          // On définit l'annonce à partir de laquelle commencer la liste
          ->setFirstResult(($page-1) * $nbPerPage)
          // Ainsi que le nombre d'annonce à afficher sur une page
          ->setMaxResults($nbPerPage)
        ;

        // Enfin, on retourne l'objet Paginator correspondant à la requête construite
        // (n'oubliez pas le use correspondant en début de fichier)
        return new Paginator($query, true);
    }

        public function getJoueursCh($id)
    {

           $query = $this->_em->createQuery('SELECT j FROM swsBackBundle:Joueurs j WHERE j.status = 1 and j.id not in (SELECT IDENTITY(ch.joueur_id) FROM swsBackBundle:ChJoueur ch WHERE ch.chcorporation_id = :id) order by j.nom ASC');

        //SELECT * FROM salles t1 where t1.sallesId not in (select sallesId from chSalles t2 where t2.championnatId = "'.$idChampionnat.'") and t1.status = 1

        $query->setParameter('id', $id);

        $results = $query->getResult();

        return $results;

    }

}
