<?php

namespace sws\Bundle\BackBundle\Entity;

use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;


/**
 * Joueurs
 *
 * @ORM\Table(name="Joueurs")
 * @ORM\Entity(repositoryClass="sws\Bundle\BackBundle\Entity\JoueursRepository")
 * @UniqueEntity(fields="numAft", message="Ce joueur semble déjà exister (numéro AFT déjà existant)")
 */
class Joueurs
{

    public function __construct()
    {
        $this->status            = true;
    }

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @Assert\NotBlank()
     * @var string
     *
     * @ORM\Column(name="nom", type="string", length=255)
     */
    private $nom;

    /**
     * @Assert\NotBlank()
     * @var string
     *
     * @ORM\Column(name="prenom", type="string", length=255)
     */
    private $prenom;

    /**
     * @Assert\NotBlank()
     * @var string
     *
     * @ORM\Column(name="sexe", type="string", length=1)
     */
    private $sexe;

    /**
     * @var string
     *
     * @ORM\Column(name="rue", type="string", length=255, nullable=true)
     */
    private $rue;

    /**
     * @var integer
     *
     * @ORM\Column(name="numRue", type="integer", nullable=true)
     */
    private $numRue;

    /**
     * @Assert\Type(type="string")
     * @var string
     *
     * @ORM\Column(name="boiteNumero", type="string", length=255, nullable=true)
     */
    private $boiteNumero;

    /**
     * @var integer
     *
     * @ORM\Column(name="codePostal", type="integer", nullable=true)
     */
    private $codePostal;

    /**
     * @var string
     *
     * @ORM\Column(name="commune", type="string", length=255, nullable=true)
     */
    private $commune;

    /**
     * @var string
     *
     * @ORM\Column(name="telPrive", type="string", length=255, nullable=true)
     */
    private $telPrive;

    /**
     * @var string
     *
     * @ORM\Column(name="gsmPrive", type="string", length=255, nullable=true)
     */
    private $gsmPrive;

    /**
     * @var string
     *
     * @ORM\Column(name="faxPrive", type="string", length=255, nullable=true)
     */
    private $faxPrive;

    /**
     * @Assert\Email()
     * @var string
     *
     * @ORM\Column(name="emailPrive", type="string", length=255, nullable=true)
     */
    private $emailPrive;

    /**
     * @var string
     *
     * @ORM\Column(name="telPro", type="string", length=255, nullable=true)
     */
    private $telPro;

    /**
     * @var string
     *
     * @ORM\Column(name="gsmPro", type="string", length=255, nullable=true)
     */
    private $gsmPro;

    /**
     * @var string
     *
     * @ORM\Column(name="faxPro", type="string", length=255, nullable=true)
     */
    private $faxPro;

    /**
     * @Assert\Email()
     * @var string
     *
     * @ORM\Column(name="emailPro", type="string", length=255, nullable=true)
     */
    private $emailPro;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateNaissance", type="date", nullable=true)
     */
    private $dateNaissance;

    /**
     * @Assert\Type(type="integer")
     * @var integer
     *
     * @ORM\Column(name="numAft", type="integer", nullable=true, unique=true)
     */
    private $numAft;

    /**
     * @Assert\Type(type="integer")
     * @var integer
     *
     * @ORM\Column(name="numClubAft", type="integer", nullable=true)
     */
    private $numClubAft;

    /**
     * @var string
     *
     * @ORM\Column(name="nomClubAft", type="string", length=255, nullable=true)
     */
    private $nomClubAft;    

    /**
     * @Assert\Type(type="integer")
     * @var integer
     *
     * @ORM\Column(name="numRil", type="integer", nullable=true)
     */
    private $numRil;

    /**
     * @var string
     *
     * @ORM\Column(name="status", type="boolean")
     */
    private $status;

    /**
     * @var string
     *
     * @ORM\Column(name="ghost", type="boolean")
     */
    private $ghost;

    /**
     * @var \DateTime
     *
     * @Gedmo\Timestampable(on="create")
     * @ORM\Column(name="createdAt", type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="update")
     * @ORM\Column(name="updatedAt", type="datetime")
     */
    private $updatedAt;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="joueurs")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     */
    protected $user;

    /**
     * @Gedmo\Slug(fields={"nom","prenom","numAft"})
     * @ORM\Column(length=128, unique=true)
     */

    private $slug;    

    /**
     * @return mixed
     */
    public function getSlug()
    {
        return $this->slug;
    }      

    /**
     * @return string
     */
    public function getNomClubAft()
    {
        return $this->nomClubAft;
    }

    /**
     * @param string $nomClubAft
     */
    public function setNomClubAft($nomClubAft)
    {
        $this->nomClubAft = $nomClubAft;
    }

    /**
     * @return string
     */
    public function getSexe()
    {
        return $this->sexe;
    }

    /**
     * @param string $sexe
     */
    public function setSexe($sexe)
    {
        $this->sexe = $sexe;
    }

    /**
     * @return mixed
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @param mixed $user
     */
    public function setUser($user)
    {
        $this->user = $user;
    }

     /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nom
     *
     * @param string $nom
     * @return Joueurs
     */
    public function setNom($nom)
    {
        $this->nom = $nom;

        return $this;
    }

    /**
     * Get nom
     *
     * @return string 
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * Set prenom
     *
     * @param string $prenom
     * @return Joueurs
     */
    public function setPrenom($prenom)
    {
        $this->prenom = $prenom;

        return $this;
    }

    /**
     * Get prenom
     *
     * @return string 
     */
    public function getPrenom()
    {
        return $this->prenom;
    }

    /**
     * Set rue
     *
     * @param string $rue
     * @return Joueurs
     */
    public function setRue($rue)
    {
        $this->rue = $rue;

        return $this;
    }

    /**
     * Get rue
     *
     * @return string 
     */
    public function getRue()
    {
        return $this->rue;
    }

    /**
     * Set numRue
     *
     * @param integer $numRue
     * @return Joueurs
     */
    public function setNumRue($numRue)
    {
        $this->numRue = $numRue;

        return $this;
    }

    /**
     * Get numRue
     *
     * @return integer 
     */
    public function getNumRue()
    {
        return $this->numRue;
    }

    /**
     * Set boiteNumero
     *
     * @param string $boiteNumero
     * @return Joueurs
     */
    public function setBoiteNumero($boiteNumero)
    {
        $this->boiteNumero = $boiteNumero;

        return $this;
    }

    /**
     * Get boiteNumero
     *
     * @return string 
     */
    public function getBoiteNumero()
    {
        return $this->boiteNumero;
    }

    /**
     * Set codePostal
     *
     * @param integer $codePostal
     * @return Joueurs
     */
    public function setCodePostal($codePostal)
    {
        $this->codePostal = $codePostal;

        return $this;
    }

    /**
     * Get codePostal
     *
     * @return integer 
     */
    public function getCodePostal()
    {
        return $this->codePostal;
    }

    /**
     * Set commune
     *
     * @param string $commune
     * @return Joueurs
     */
    public function setCommune($commune)
    {
        $this->commune = $commune;

        return $this;
    }

    /**
     * Get commune
     *
     * @return string 
     */
    public function getCommune()
    {
        return $this->commune;
    }

    /**
     * Set telPrive
     *
     * @param string $telPrive
     * @return Joueurs
     */
    public function setTelPrive($telPrive)
    {
        $this->telPrive = $telPrive;

        return $this;
    }

    /**
     * Get telPrive
     *
     * @return string 
     */
    public function getTelPrive()
    {
        return $this->telPrive;
    }

    /**
     * Set gsmPrive
     *
     * @param string $gsmPrive
     * @return Joueurs
     */
    public function setGsmPrive($gsmPrive)
    {
        $this->gsmPrive = $gsmPrive;

        return $this;
    }

    /**
     * Get gsmPrive
     *
     * @return string 
     */
    public function getGsmPrive()
    {
        return $this->gsmPrive;
    }

    /**
     * Set faxPrive
     *
     * @param string $faxPrive
     * @return Joueurs
     */
    public function setFaxPrive($faxPrive)
    {
        $this->faxPrive = $faxPrive;

        return $this;
    }

    /**
     * Get faxPrive
     *
     * @return string 
     */
    public function getFaxPrive()
    {
        return $this->faxPrive;
    }

    /**
     * Set emailPrive
     *
     * @param string $emailPrive
     * @return Joueurs
     */
    public function setEmailPrive($emailPrive)
    {
        $this->emailPrive = $emailPrive;

        return $this;
    }

    /**
     * Get emailPrive
     *
     * @return string 
     */
    public function getEmailPrive()
    {
        return $this->emailPrive;
    }

    /**
     * Set telPro
     *
     * @param string $telPro
     * @return Joueurs
     */
    public function setTelPro($telPro)
    {
        $this->telPro = $telPro;

        return $this;
    }

    /**
     * Get telPro
     *
     * @return string 
     */
    public function getTelPro()
    {
        return $this->telPro;
    }

    /**
     * Set gsmPro
     *
     * @param string $gsmPro
     * @return Joueurs
     */
    public function setGsmPro($gsmPro)
    {
        $this->gsmPro = $gsmPro;

        return $this;
    }

    /**
     * Get gsmPro
     *
     * @return string 
     */
    public function getGsmPro()
    {
        return $this->gsmPro;
    }

    /**
     * Set faxPro
     *
     * @param string $faxPro
     * @return Joueurs
     */
    public function setFaxPro($faxPro)
    {
        $this->faxPro = $faxPro;

        return $this;
    }

    /**
     * Get faxPro
     *
     * @return string 
     */
    public function getFaxPro()
    {
        return $this->faxPro;
    }

    /**
     * Set emailPro
     *
     * @param string $emailPro
     * @return Joueurs
     */
    public function setEmailPro($emailPro)
    {
        $this->emailPro = $emailPro;

        return $this;
    }

    /**
     * Get emailPro
     *
     * @return string 
     */
    public function getEmailPro()
    {
        return $this->emailPro;
    }

    /**
     * Set dateNaissance
     *
     * @param \DateTime $dateNaissance
     * @return Joueurs
     */
    public function setDateNaissance($dateNaissance)
    {
        $this->dateNaissance = $dateNaissance;

        return $this;
    }

    /**
     * Get dateNaissance
     *
     * @return \DateTime 
     */
    public function getDateNaissance()
    {
        return $this->dateNaissance;
    }

    /**
     * Set numAft
     *
     * @param integer $numAft
     * @return Joueurs
     */
    public function setNumAft($numAft)
    {
        $this->numAft = $numAft;

        return $this;
    }

    /**
     * Get numAft
     *
     * @return integer 
     */
    public function getNumAft()
    {
        return $this->numAft;
    }

    /**
     * Set numClubAft
     *
     * @param integer $numClubAft
     * @return Joueurs
     */
    public function setNumClubAft($numClubAft)
    {
        $this->numClubAft = $numClubAft;

        return $this;
    }

    /**
     * Get numClubAft
     *
     * @return integer 
     */
    public function getNumClubAft()
    {
        return $this->numClubAft;
    }

    /**
     * Set numRil
     *
     * @param integer $numRil
     * @return Joueurs
     */
    public function setNumRil($numRil)
    {
        $this->numRil = $numRil;

        return $this;
    }

    /**
     * Get numRil
     *
     * @return integer 
     */
    public function getNumRil()
    {
        return $this->numRil;
    }

    /**
     * Set status
     *
     * @param string $status
     * @return Joueurs
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return string 
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set ghost
     *
     * @param string $ghost
     * @return Joueurs
     */
    public function setGhost($ghost)
    {
        $this->ghost = $ghost;

        return $this;
    }

    /**
     * Get ghost
     *
     * @return string 
     */
    public function getGhost()
    {
        return $this->ghost;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime 
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Get updatedAt
     *
     * @return \DateTime 
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }
}
