<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Tools\Pagination\Paginator;

/**
 * CorporationRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class CorporationRepository extends EntityRepository
{
    public function getAll()
    {
        $qb = $this->createQueryBuilder('c');

        $query = $qb;

        $result = $qb->getQuery()->getArrayResult();
        return $result;
    }

    public function getCorporations($page, $nbPerPage)
    {
        $query = $this->createQueryBuilder('c')
            ->join('c.typecorpo', 'tc')
            ->addSelect('tc')
            ->orderBy('c.nom', 'ASC')
            ->getQuery()
        ;

        $query
            ->setFirstResult(($page-1) * $nbPerPage)
            ->setMaxResults($nbPerPage)
        ;

        return new Paginator($query, true);
    }

    public function getCorporationsByCritere($critere, $page, $nbPerPage)
    {
        $query = $this->createQueryBuilder('c');

        $query
            ->join('c.typecorpo', 'tc')
            ->addSelect('tc')
            ->where('c.nom like :critere')
            ->setParameter('critere', '%'.$critere.'%')
            ->orderBy('c.nom', 'ASC')
            ->setFirstResult(($page-1) * $nbPerPage)
            ->setMaxResults($nbPerPage)
        ;

        return new Paginator($query, true);
    }

    public function getCorporationsCh($id)
    {
        $query = $this->_em->createQuery('SELECT s FROM swsBackBundle:Corporation s WHERE s.status = 1 and s.id not in (SELECT IDENTITY(ch.corporation_id) FROM swsBackBundle:ChCorporation ch WHERE ch.championnat_id = :id) ');

        $query->setParameter('id', $id);

        $results = $query->getResult();

        return $results;
    }

}
