<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Corporation
 *
 * @ORM\Table(name="Corporation")
 * @ORM\Entity(repositoryClass="sws\Bundle\BackBundle\Entity\CorporationRepository")
 */
class Corporation
{
    public function __construct()
    {
        $this->status            = true;
    }

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @Assert\NotBlank()
     * @var string
     *
     * @ORM\Column(name="nom", type="string", length=255)
     */
    private $nom;

    /**
     * @Assert\NotBlank()
     * @var string
     *
     * @ORM\Column(name="nomSuccinct", type="string", length=255)
     */
    private $nomSuccinct;

    /**
     * @ORM\ManyToOne(targetEntity="TypeCorpo", inversedBy="typeCorpos2")
     * @ORM\JoinColumn(name="typecorpo_id", referencedColumnName="id")
     */
    protected $typecorpo;

    /**
     * @var string
     *
     * @ORM\Column(name="genre", type="string", length=1)
     */
    private $genre;    

    /**
     * @Assert\Type(type="integer")
     * @Assert\NotBlank()
     * @var integer
     *
     * @ORM\Column(name="numeroId", type="integer")
     */
    private $numeroId;

    /**
     * @var string
     *
     * @ORM\Column(name="rue", type="string", length=255, nullable=true)
     */
    private $rue;

    /**
     * @var integer
     *
     * @ORM\Column(name="numeroRue", type="integer", nullable=true)
     */
    private $numeroRue;

    /**
     * @var string
     *
     * @ORM\Column(name="boiteNumero", type="string", length=5, nullable=true)
     */
    private $boiteNumero;

    /**
     * @var integer
     *
     * @ORM\Column(name="codePostal", type="integer", nullable=true)
     */
    private $codePostal;

    /**
     * @var string
     *
     * @ORM\Column(name="commune", type="string", length=255, nullable=true)
     */
    private $commune;

    /**
     * @var string
     *
     * @ORM\Column(name="description", type="text", nullable=true)
     */
    private $description;

    /**
     * @var string
     *
     * @ORM\Column(name="nomPresident", type="string", length=255, nullable=true)
     */
    private $nomPresident;

    /**
     * @var string
     *
     * @ORM\Column(name="prenomPresident", type="string", length=255, nullable=true)
     */
    private $prenomPresident;

    /**
     * @var string
     *
     * @ORM\Column(name="ruePresident", type="string", length=255, nullable=true)
     */
    private $ruePresident;

    /**
     * @var integer
     *
     * @ORM\Column(name="numeroRuePresident", type="integer", nullable=true)
     */
    private $numeroRuePresident;

    /**
     * @var string
     *
     * @ORM\Column(name="boiteNumeroRuePresident", type="string", length=5, nullable=true)
     */
    private $boiteNumeroRuePresident;

    /**
     * @var integer
     *
     * @ORM\Column(name="codePostalPresident", type="integer", nullable=true)
     */
    private $codePostalPresident;

    /**
     * @var string
     *
     * @ORM\Column(name="communePresident", type="string", length=255, nullable=true)
     */
    private $communePresident;

    /**
     * @var string
     *
     * @ORM\Column(name="telPrivePresident", type="string", length=255, nullable=true, nullable=true)
     */
    private $telPrivePresident;

    /**
     * @var string
     *
     * @ORM\Column(name="gsmPrivePresident", type="string", length=255, nullable=true, nullable=true)
     */
    private $gsmPrivePresident;

    /**
     * @Assert\Email()
     * @var string
     *
     * @ORM\Column(name="emailPrivePresident", type="string", length=255, nullable=true, nullable=true)
     */
    private $emailPrivePresident;

     /**
     * @var string
     *
     * @ORM\Column(name="nomVicePresident", type="string", length=255, nullable=true)
     */
    private $nomVicePresident;

    /**
     * @var string
     *
     * @ORM\Column(name="prenomVicePresident", type="string", length=255, nullable=true)
     */
    private $prenomVicePresident;

    /**
     * @var string
     *
     * @ORM\Column(name="rueVicePresident", type="string", length=255, nullable=true)
     */
    private $rueVicePresident;

    /**
     * @var integer
     *
     * @ORM\Column(name="numeroRueVicePresident", type="integer", nullable=true)
     */
    private $numeroRueVicePresident;

    /**
     * @var string
     *
     * @ORM\Column(name="boiteNumeroRueVicePresident", type="string", length=5, nullable=true)
     */
    private $boiteNumeroRueVicePresident;

    /**
     * @var integer
     *
     * @ORM\Column(name="codePostalVicePresident", type="integer", nullable=true)
     */
    private $codePostalVicePresident;

    /**
     * @var string
     *
     * @ORM\Column(name="communeVicePresident", type="string", length=255, nullable=true)
     */
    private $communeVicePresident;

    /**
     * @var string
     *
     * @ORM\Column(name="telPriveVicePresident", type="string", length=255, nullable=true, nullable=true)
     */
    private $telPriveVicePresident;

    /**
     * @var string
     *
     * @ORM\Column(name="gsmPriveVicePresident", type="string", length=255, nullable=true, nullable=true)
     */
    private $gsmPriveVicePresident;

    /**
     * @Assert\Email()
     * @var string
     *
     * @ORM\Column(name="emailPriveVicePresident", type="string", length=255, nullable=true, nullable=true)
     */
    private $emailPriveVicePresident;

    /**
     * @var string
     *
     * @ORM\Column(name="nomTresorier", type="string", length=255, nullable=true)
     */
    private $nomTresorier;

    /**
     * @var string
     *
     * @ORM\Column(name="prenomTresorier", type="string", length=255, nullable=true)
     */
    private $prenomTresorier;

    /**
     * @var string
     *
     * @ORM\Column(name="rueTresorier", type="string", length=255, nullable=true)
     */
    private $rueTresorier;

    /**
     * @var integer
     *
     * @ORM\Column(name="numeroRueTresorier", type="integer", nullable=true)
     */
    private $numeroRueTresorier;

    /**
     * @var string
     *
     * @ORM\Column(name="boiteNumeroRueTresorier", type="string", length=5, nullable=true)
     */
    private $boiteNumeroRueTresorier;

    /**
     * @var integer
     *
     * @ORM\Column(name="codePostalTresorier", type="integer", nullable=true)
     */
    private $codePostalTresorier;

    /**
     * @var string
     *
     * @ORM\Column(name="communeTresorier", type="string", length=255, nullable=true)
     */
    private $communeTresorier;

    /**
     * @var string
     *
     * @ORM\Column(name="telPriveTresorier", type="string", length=255, nullable=true)
     */
    
    private $telPriveTresorier;

    /**
     * @var string
     *
     * @ORM\Column(name="gsmPriveTresorier", type="string", length=255, nullable=true)
     */
    private $gsmPriveTresorier;

    /**
     * @Assert\Email()
     * @var string
     *
     * @ORM\Column(name="emailPriveTresorier", type="string", length=255, nullable=true)
     */
    private $emailPriveTresorier;

    /**
     * @var string
     *
     * @ORM\Column(name="nomSecretaire", type="string", length=255, nullable=true)
     */
    private $nomSecretaire;

    /**
     * @var string
     *
     * @ORM\Column(name="prenomSecretaire", type="string", length=255, nullable=true)
     */
    private $prenomSecretaire;

    /**
     * @var string
     *
     * @ORM\Column(name="rueSecretaire", type="string", length=255, nullable=true)
     */
    private $rueSecretaire;

    /**
     * @var integer
     *
     * @ORM\Column(name="numeroRueSecretaire", type="integer", nullable=true)
     */
    private $numeroRueSecretaire;

    /**
     * @var string
     *
     * @ORM\Column(name="boiteNumeroRueSecretaire", type="string", length=5, nullable=true)
     */
    private $boiteNumeroRueSecretaire;

    /**
     * @var integer
     *
     * @ORM\Column(name="codePostalSecretaire", type="integer", nullable=true)
     */
    private $codePostalSecretaire;

    /**
     * @var string
     *
     * @ORM\Column(name="communeSecretaire", type="string", length=255, nullable=true)
     */
    private $communeSecretaire;

    /**
     * @var string
     *
     * @ORM\Column(name="telPriveSecretaire", type="string", length=255, nullable=true, nullable=true)
     */

    private $telPriveSecretaire;

    /**
     * @var string
     *
     * @ORM\Column(name="gsmPriveSecretaire", type="string", length=255, nullable=true)
     */
    private $gsmPriveSecretaire;

    /**
     * @Assert\Email()
     * @var string
     *
     * @ORM\Column(name="emailPriveSecretaire", type="string", length=255, nullable=true)
     */
    private $emailPriveSecretaire;   

    /**
     * @Assert\Type(type="boolean")
     * @var boolean
     *
     * @ORM\Column(name="status", type="boolean", nullable=true)
     */
    private $status;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="create")
     * @ORM\Column(name="createdAt", type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="update")
     * @ORM\Column(name="updatedAt", type="datetime")
     */
    private $updatedAt;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="corporations")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     */
    protected $user;

    /**
     * @Gedmo\Slug(fields={"nom","numeroId"})
     * @ORM\Column(length=128, unique=true)
     */

    private $slug;

    /**
     * @Assert\File(maxSize="100000")
     */
    public $file;

    /**
     * @var string
     *
     * @ORM\Column(name="path", type="string", length=255, nullable=true)
     */
    private $path;

    /**
     * @return string
     */
    public function getPath()
    {
        return $this->path;
    }

    /**
     * @param string $path
     */
    public function setPath($path)
    {
        $this->path = $path;
    }

    public function getAbsolutePath()
    {
        return null === $this->path ? null : $this->getUploadRootDir().'/'.$this->path;
    }

    public function getWebPath()
    {
        return null === $this->path ? null : $this->getUploadDir().'/'.$this->path;
    }

    protected function getUploadRootDir()
    {
        // le chemin absolu du répertoire où les documents uploadés doivent être sauvegardés
        return __DIR__.'/../../../../../'.$this->getUploadDir();
    }

    protected function getUploadDir()
    {
        // on se débarrasse de « __DIR__ » afin de ne pas avoir de problème lorsqu'on affiche
        // le document/image dans la vue.
        return '/web/uploads/logos/corporations/';
    }

    public function upload()
    {
        // la propriété « file » peut être vide si le champ n'est pas requis
        if (null === $this->file) {
            $this->path = '/bundles/front2/images/logoRil21x18.png';
            return;
        }

        // utilisez le nom de fichier original ici mais
        // vous devriez « l'assainir » pour au moins éviter
        // quelconques problèmes de sécurité

        // la méthode « move » prend comme arguments le répertoire cible et
        // le nom de fichier cible où le fichier doit être déplacé
        $this->file->move($this->getUploadRootDir(), $this->file->getClientOriginalName());

        // définit la propriété « path » comme étant le nom de fichier où vous
        // avez stocké le fichier

        // sws-todo : Gerer l'obfuscation du nom de l'image
        $this->path = '/web/uploads/logos/corporations/'.$this->file->getClientOriginalName();

        // « nettoie » la propriété « file » comme vous n'en aurez plus besoin
        $this->file = null;
    }

    /**
     * @return mixed
     */
    public function getSlug()
    {
        return $this->slug;
    }  


    /**
     * @return mixed
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @param mixed $user
     */
    public function setUser($user)
    {
        $this->user = $user;
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nom
     *
     * @param string $nom
     * @return Corporation
     */
    public function setNom($nom)
    {
        $this->nom = $nom;

        return $this;
    }

    /**
     * Get nom
     *
     * @return string 
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * Set nomSuccinct
     *
     * @param string $nomSuccinct
     * @return Corporation
     */
    public function setNomSuccinct($nomSuccinct)
    {
        $this->nomSuccinct = $nomSuccinct;

        return $this;
    }

    /**
     * Get nomSuccinct
     *
     * @return string 
     */
    public function getNomSuccinct()
    {
        return $this->nomSuccinct;
    }

    /**
     * Set typecorpo
     *
     * @param string $typecorpo
     * @return Corporation
     */
    public function setTypecorpo($typecorpo)
    {
        $this->typecorpo = $typecorpo;

        return $this;
    }

    /**
     * Get typecorpo
     *
     * @return string 
     */
    public function getTypecorpo()
    {
        return $this->typecorpo;
    }

   /**
     * @return string
     */
    public function getGenre()
    {
        return $this->genre;
    }

    /**
     * @param string $genre
     */
    public function setGenre($genre)
    {
        $this->genre = $genre;
    }
    

    /**
     * Set numeroId
     *
     * @param integer $numeroId
     * @return Corporation
     */
    public function setNumeroId($numeroId)
    {
        $this->numeroId = $numeroId;

        return $this;
    }

    /**
     * Get numeroId
     *
     * @return integer 
     */
    public function getNumeroId()
    {
        return $this->numeroId;
    }

    /**
     * Set rue
     *
     * @param string $rue
     * @return Corporation
     */
    public function setRue($rue)
    {
        $this->rue = $rue;

        return $this;
    }

    /**
     * Get rue
     *
     * @return string 
     */
    public function getRue()
    {
        return $this->rue;
    }

    /**
     * Set numeroRue
     *
     * @param integer $numeroRue
     * @return Corporation
     */
    public function setNumeroRue($numeroRue)
    {
        $this->numeroRue = $numeroRue;

        return $this;
    }

    /**
     * Get numeroRue
     *
     * @return integer 
     */
    public function getNumeroRue()
    {
        return $this->numeroRue;
    }

    /**
     * Set boiteNumero
     *
     * @param string $boiteNumero
     * @return Corporation
     */
    public function setBoiteNumero($boiteNumero)
    {
        $this->boiteNumero = $boiteNumero;

        return $this;
    }

    /**
     * Get boiteNumero
     *
     * @return string 
     */
    public function getBoiteNumero()
    {
        return $this->boiteNumero;
    }

    /**
     * Set codePostal
     *
     * @param integer $codePostal
     * @return Corporation
     */
    public function setCodePostal($codePostal)
    {
        $this->codePostal = $codePostal;

        return $this;
    }

    /**
     * Get codePostal
     *
     * @return integer 
     */
    public function getCodePostal()
    {
        return $this->codePostal;
    }

    /**
     * Set commune
     *
     * @param string $commune
     * @return Corporation
     */
    public function setCommune($commune)
    {
        $this->commune = $commune;

        return $this;
    }

    /**
     * Get commune
     *
     * @return string 
     */
    public function getCommune()
    {
        return $this->commune;
    }

    /**
     * Set description
     *
     * @param string $description
     * @return Corporation
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description
     *
     * @return string 
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set nomPresident
     *
     * @param string $nomPresident
     * @return Corporation
     */
    public function setNomPresident($nomPresident)
    {
        $this->nomPresident = $nomPresident;

        return $this;
    }

    /**
     * Get nomPresident
     *
     * @return string 
     */
    public function getNomPresident()
    {
        return $this->nomPresident;
    }

    /**
     * Set prenomPresident
     *
     * @param string $prenomPresident
     * @return Corporation
     */
    public function setPrenomPresident($prenomPresident)
    {
        $this->prenomPresident = $prenomPresident;

        return $this;
    }

    /**
     * Get prenomPresident
     *
     * @return string 
     */
    public function getPrenomPresident()
    {
        return $this->prenomPresident;
    }

    /**
     * Set ruePresident
     *
     * @param string $ruePresident
     * @return Corporation
     */
    public function setRuePresident($ruePresident)
    {
        $this->ruePresident = $ruePresident;

        return $this;
    }

    /**
     * Get ruePresident
     *
     * @return string 
     */
    public function getRuePresident()
    {
        return $this->ruePresident;
    }

    /**
     * Set numeroRuePresident
     *
     * @param integer $numeroRuePresident
     * @return Corporation
     */
    public function setNumeroRuePresident($numeroRuePresident)
    {
        $this->numeroRuePresident = $numeroRuePresident;

        return $this;
    }

    /**
     * Get numeroRuePresident
     *
     * @return integer 
     */
    public function getNumeroRuePresident()
    {
        return $this->numeroRuePresident;
    }

    /**
     * Set boiteNumeroRuePresident
     *
     * @param string $boiteNumeroRuePresident
     * @return Corporation
     */
    public function setBoiteNumeroRuePresident($boiteNumeroRuePresident)
    {
        $this->boiteNumeroRuePresident = $boiteNumeroRuePresident;

        return $this;
    }

    /**
     * Get boiteNumeroRuePresident
     *
     * @return string 
     */
    public function getBoiteNumeroRuePresident()
    {
        return $this->boiteNumeroRuePresident;
    }

    /**
     * Set codePostalPresident
     *
     * @param integer $codePostalPresident
     * @return Corporation
     */
    public function setCodePostalPresident($codePostalPresident)
    {
        $this->codePostalPresident = $codePostalPresident;

        return $this;
    }

    /**
     * Get codePostalPresident
     *
     * @return integer 
     */
    public function getCodePostalPresident()
    {
        return $this->codePostalPresident;
    }

    /**
     * Set communePresident
     *
     * @param string $communePresident
     * @return Corporation
     */
    public function setCommunePresident($communePresident)
    {
        $this->communePresident = $communePresident;

        return $this;
    }

    /**
     * Get communePresident
     *
     * @return string 
     */
    public function getCommunePresident()
    {
        return $this->communePresident;
    }

    /**
     * Set nomVicePresident
     *
     * @param string $nomVicePresident
     * @return Corporation
     */
    public function setNomVicePresident($nomVicePresident)
    {
        $this->nomVicePresident = $nomVicePresident;

        return $this;
    }

    /**
     * Get nomVicePresident
     *
     * @return string 
     */
    public function getNomVicePresident()
    {
        return $this->nomVicePresident;
    }

    /**
     * Set prenomVicePresident
     *
     * @param string $prenomVicePresident
     * @return Corporation
     */
    public function setPrenomVicePresident($prenomVicePresident)
    {
        $this->prenomVicePresident = $prenomVicePresident;

        return $this;
    }

    /**
     * Get prenomVicePresident
     *
     * @return string 
     */
    public function getPrenomVicePresident()
    {
        return $this->prenomVicePresident;
    }

    /**
     * Set rueVicePresident
     *
     * @param string $rueVicePresident
     * @return Corporation
     */
    public function setRueVicePresident($rueVicePresident)
    {
        $this->rueVicePresident = $rueVicePresident;

        return $this;
    }

    /**
     * Get rueVicePresident
     *
     * @return string 
     */
    public function getRueVicePresident()
    {
        return $this->rueVicePresident;
    }

    /**
     * Set numeroRueVicePresident
     *
     * @param integer $numeroRueVicePresident
     * @return Corporation
     */
    public function setNumeroRueVicePresident($numeroRueVicePresident)
    {
        $this->numeroRueVicePresident = $numeroRueVicePresident;

        return $this;
    }

    /**
     * Get numeroRueVicePresident
     *
     * @return integer 
     */
    public function getNumeroRueVicePresident()
    {
        return $this->numeroRueVicePresident;
    }

    /**
     * Set boiteNumeroRueVicePresident
     *
     * @param string $boiteNumeroRueVicePresident
     * @return Corporation
     */
    public function setBoiteNumeroRueVicePresident($boiteNumeroRueVicePresident)
    {
        $this->boiteNumeroRueVicePresident = $boiteNumeroRueVicePresident;

        return $this;
    }

    /**
     * Get boiteNumeroRueVicePresident
     *
     * @return string 
     */
    public function getBoiteNumeroRueVicePresident()
    {
        return $this->boiteNumeroRueVicePresident;
    }

    /**
     * Set codePostalVicePresident
     *
     * @param integer $codePostalVicePresident
     * @return Corporation
     */
    public function setCodePostalVicePresident($codePostalVicePresident)
    {
        $this->codePostalVicePresident = $codePostalVicePresident;

        return $this;
    }

    /**
     * Get codePostalVicePresident
     *
     * @return integer 
     */
    public function getCodePostalVicePresident()
    {
        return $this->codePostalVicePresident;
    }

    /**
     * Set communeVicePresident
     *
     * @param string $communeVicePresident
     * @return Corporation
     */
    public function setCommuneVicePresident($communeVicePresident)
    {
        $this->communeVicePresident = $communeVicePresident;

        return $this;
    }

    /**
     * Get communeVicePresident
     *
     * @return string 
     */
    public function getCommuneVicePresident()
    {
        return $this->communeVicePresident;
    }

    /**
     * Set nomTresorier
     *
     * @param string $nomTresorier
     * @return Corporation
     */
    public function setNomTresorier($nomTresorier)
    {
        $this->nomTresorier = $nomTresorier;

        return $this;
    }

    /**
     * Get nomTresorier
     *
     * @return string 
     */
    public function getNomTresorier()
    {
        return $this->nomTresorier;
    }

    /**
     * Set prenomTresorier
     *
     * @param string $prenomTresorier
     * @return Corporation
     */
    public function setPrenomTresorier($prenomTresorier)
    {
        $this->prenomTresorier = $prenomTresorier;

        return $this;
    }

    /**
     * Get prenomTresorier
     *
     * @return string 
     */
    public function getPrenomTresorier()
    {
        return $this->prenomTresorier;
    }

    /**
     * Set rueTresorier
     *
     * @param string $rueTresorier
     * @return Corporation
     */
    public function setRueTresorier($rueTresorier)
    {
        $this->rueTresorier = $rueTresorier;

        return $this;
    }

    /**
     * Get rueTresorier
     *
     * @return string 
     */
    public function getRueTresorier()
    {
        return $this->rueTresorier;
    }

    /**
     * Set numeroRueTresorier
     *
     * @param integer $numeroRueTresorier
     * @return Corporation
     */
    public function setNumeroRueTresorier($numeroRueTresorier)
    {
        $this->numeroRueTresorier = $numeroRueTresorier;

        return $this;
    }

    /**
     * Get numeroRueTresorier
     *
     * @return integer 
     */
    public function getNumeroRueTresorier()
    {
        return $this->numeroRueTresorier;
    }

    /**
     * Set boiteNumeroRueTresorier
     *
     * @param string $boiteNumeroRueTresorier
     * @return Corporation
     */
    public function setBoiteNumeroRueTresorier($boiteNumeroRueTresorier)
    {
        $this->boiteNumeroRueTresorier = $boiteNumeroRueTresorier;

        return $this;
    }

    /**
     * Get boiteNumeroRueTresorier
     *
     * @return string 
     */
    public function getBoiteNumeroRueTresorier()
    {
        return $this->boiteNumeroRueTresorier;
    }

    /**
     * Set codePostalTresorier
     *
     * @param integer $codePostalTresorier
     * @return Corporation
     */
    public function setCodePostalTresorier($codePostalTresorier)
    {
        $this->codePostalTresorier = $codePostalTresorier;

        return $this;
    }

    /**
     * Get codePostalTresorier
     *
     * @return integer 
     */
    public function getCodePostalTresorier()
    {
        return $this->codePostalTresorier;
    }

    /**
     * Set communeTresorier
     *
     * @param string $communeTresorier
     * @return Corporation
     */
    public function setCommuneTresorier($communeTresorier)
    {
        $this->communeTresorier = $communeTresorier;

        return $this;
    }

    /**
     * Get communeTresorier
     *
     * @return string 
     */
    public function getCommuneTresorier()
    {
        return $this->communeTresorier;
    }

    /**
     * Set nomSecretaire
     *
     * @param string $nomSecretaire
     * @return Corporation
     */
    public function setNomSecretaire($nomSecretaire)
    {
        $this->nomSecretaire = $nomSecretaire;

        return $this;
    }

    /**
     * Get nomSecretaire
     *
     * @return string 
     */
    public function getNomSecretaire()
    {
        return $this->nomSecretaire;
    }

    /**
     * Set prenomSecretaire
     *
     * @param string $prenomSecretaire
     * @return Corporation
     */
    public function setPrenomSecretaire($prenomSecretaire)
    {
        $this->prenomSecretaire = $prenomSecretaire;

        return $this;
    }

    /**
     * Get prenomSecretaire
     *
     * @return string 
     */
    public function getPrenomSecretaire()
    {
        return $this->prenomSecretaire;
    }

    /**
     * Set rueSecretaire
     *
     * @param string $rueSecretaire
     * @return Corporation
     */
    public function setRueSecretaire($rueSecretaire)
    {
        $this->rueSecretaire = $rueSecretaire;

        return $this;
    }

    /**
     * Get rueSecretaire
     *
     * @return string 
     */
    public function getRueSecretaire()
    {
        return $this->rueSecretaire;
    }

    /**
     * Set numeroRueSecretaire
     *
     * @param integer $numeroRueSecretaire
     * @return Corporation
     */
    public function setNumeroRueSecretaire($numeroRueSecretaire)
    {
        $this->numeroRueSecretaire = $numeroRueSecretaire;

        return $this;
    }

    /**
     * Get numeroRueSecretaire
     *
     * @return integer 
     */
    public function getNumeroRueSecretaire()
    {
        return $this->numeroRueSecretaire;
    }

    /**
     * Set boiteNumeroRueSecretaire
     *
     * @param string $boiteNumeroRueSecretaire
     * @return Corporation
     */
    public function setBoiteNumeroRueSecretaire($boiteNumeroRueSecretaire)
    {
        $this->boiteNumeroRueSecretaire = $boiteNumeroRueSecretaire;

        return $this;
    }

    /**
     * Get boiteNumeroRueSecretaire
     *
     * @return string 
     */
    public function getBoiteNumeroRueSecretaire()
    {
        return $this->boiteNumeroRueSecretaire;
    }

    /**
     * Set codePostalSecretaire
     *
     * @param integer $codePostalSecretaire
     * @return Corporation
     */
    public function setCodePostalSecretaire($codePostalSecretaire)
    {
        $this->codePostalSecretaire = $codePostalSecretaire;

        return $this;
    }

    /**
     * Get codePostalSecretaire
     *
     * @return integer 
     */
    public function getCodePostalSecretaire()
    {
        return $this->codePostalSecretaire;
    }

    /**
     * Set communeSecretaire
     *
     * @param string $communeSecretaire
     * @return Corporation
     */
    public function setCommuneSecretaire($communeSecretaire)
    {
        $this->communeSecretaire = $communeSecretaire;

        return $this;
    }

    /**
     * Get communeSecretaire
     *
     * @return string 
     */
    public function getCommuneSecretaire()
    {
        return $this->communeSecretaire;
    }

    /**
     * Set status
     *
     * @param boolean $status
     * @return Corporation
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return boolean 
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime 
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Get updatedAt
     *
     * @return \DateTime 
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * @return string
     */
    public function getTelPrivePresident()
    {
        return $this->telPrivePresident;
    }

    /**
     * @param string $telPrivePresident
     */
    public function setTelPrivePresident($telPrivePresident)
    {
        $this->telPrivePresident = $telPrivePresident;
    }

    /**
     * @return string
     */
    public function getGsmPrivePresident()
    {
        return $this->gsmPrivePresident;
    }

    /**
     * @param string $gsmPrivePresident
     */
    public function setGsmPrivePresident($gsmPrivePresident)
    {
        $this->gsmPrivePresident = $gsmPrivePresident;
    }

    /**
     * @return string
     */
    public function getEmailPrivePresident()
    {
        return $this->emailPrivePresident;
    }

    /**
     * @param string $emailPrivePresident
     */
    public function setEmailPrivePresident($emailPrivePresident)
    {
        $this->emailPrivePresident = $emailPrivePresident;
    }

    /**
     * @return string
     */
    public function getTelPriveVicePresident()
    {
        return $this->telPriveVicePresident;
    }

    /**
     * @param string $telPriveVicePresident
     */
    public function setTelPriveVicePresident($telPriveVicePresident)
    {
        $this->telPriveVicePresident = $telPriveVicePresident;
    }

    /**
     * @return string
     */
    public function getGsmPriveVicePresident()
    {
        return $this->gsmPriveVicePresident;
    }

    /**
     * @param string $gsmPriveVicePresident
     */
    public function setGsmPriveVicePresident($gsmPriveVicePresident)
    {
        $this->gsmPriveVicePresident = $gsmPriveVicePresident;
    }

    /**
     * @return string
     */
    public function getEmailPriveVicePresident()
    {
        return $this->emailPriveVicePresident;
    }

    /**
     * @param string $emailPriveVicePresident
     */
    public function setEmailPriveVicePresident($emailPriveVicePresident)
    {
        $this->emailPriveVicePresident = $emailPriveVicePresident;
    }

    /**
     * @return string
     */
    public function getTelPriveTresorier()
    {
        return $this->telPriveTresorier;
    }

    /**
     * @param string $telPriveTresorier
     */
    public function setTelPriveTresorier($telPriveTresorier)
    {
        $this->telPriveTresorier = $telPriveTresorier;
    }

    /**
     * @return string
     */
    public function getGsmPriveTresorier()
    {
        return $this->gsmPriveTresorier;
    }

    /**
     * @param string $gsmPriveTresorier
     */
    public function setGsmPriveTresorier($gsmPriveTresorier)
    {
        $this->gsmPriveTresorier = $gsmPriveTresorier;
    }

    /**
     * @return string
     */
    public function getEmailPriveTresorier()
    {
        return $this->emailPriveTresorier;
    }

    /**
     * @param string $emailPriveTresorier
     */
    public function setEmailPriveTresorier($emailPriveTresorier)
    {
        $this->emailPriveTresorier = $emailPriveTresorier;
    }

    /**
     * @return string
     */
    public function getTelPriveSecretaire()
    {
        return $this->telPriveSecretaire;
    }

    /**
     * @param string $telPriveSecretaire
     */
    public function setTelPriveSecretaire($telPriveSecretaire)
    {
        $this->telPriveSecretaire = $telPriveSecretaire;
    }

    /**
     * @return string
     */
    public function getGsmPriveSecretaire()
    {
        return $this->gsmPriveSecretaire;
    }

    /**
     * @param string $gsmPriveSecretaire
     */
    public function setGsmPriveSecretaire($gsmPriveSecretaire)
    {
        $this->gsmPriveSecretaire = $gsmPriveSecretaire;
    }

    /**
     * @return string
     */
    public function getEmailPriveSecretaire()
    {
        return $this->emailPriveSecretaire;
    }

    /**
     * @param string $emailPriveSecretaire
     */
    public function setEmailPriveSecretaire($emailPriveSecretaire)
    {
        $this->emailPriveSecretaire = $emailPriveSecretaire;
    }


}
