<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Tools\Pagination\Paginator;

/**
 * ChampionnatRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ChampionnatRepository extends EntityRepository
{
    public function getAll()
    {
        $qb = $this->createQueryBuilder('s');

        $query = $qb;
        /*
            ->where('j.nom = :nom')
            ->setParameter('nom', 'Bettonville');
        */
        $result = $qb->getQuery()->execute();
        return $result;
    }

    public function getChampionnats($page, $nbPerPage)
    {
        $query = $this->createQueryBuilder('s')
            ->orderBy('s.dateDebut', 'DESC')
            ->getQuery()
        ;

        $query
            // On définit l'annonce à partir de laquelle commencer la liste
            ->setFirstResult(($page-1) * $nbPerPage)
            // Ainsi que le nombre d'annonce à afficher sur une page
            ->setMaxResults($nbPerPage)
        ;

        // Enfin, on retourne l'objet Paginator correspondant à la requête construite
        // (n'oubliez pas le use correspondant en début de fichier)
        return new Paginator($query, true);
    }

    public function getChampionnatsByCritere($critere, $page, $nbPerPage)
    {
        $query = $this->createQueryBuilder('s');

        $query
            ->where('s.nom like :critere')
            ->setParameter('critere', '%'.$critere.'%')
            ->orderBy('s.dateDebut', 'DESC')
            // On définit l'annonce à partir de laquelle commencer la liste
            ->setFirstResult(($page-1) * $nbPerPage)
            // Ainsi que le nombre d'annonce à afficher sur une page
            ->setMaxResults($nbPerPage)
        ;

        // Enfin, on retourne l'objet Paginator correspondant à la requête construite
        // (n'oubliez pas le use correspondant en début de fichier)
        return new Paginator($query, true);
    }

    public function removeTdbChampionnats($id)
    {

        $query = $this->_em->createQuery("UPDATE sws\Bundle\BackBundle\Entity\Championnat c SET c.setTdb = 0 WHERE c.id <> " .$id);
        $result = $query->execute();

        return $result;

    }

    public function getTopJoueur($idChampionnat, $limit)
    {

        $query = ("

            SELECT s.pointsJoueur + d.pointsJoueur AS points, s.pointsJoueur AS pointsSimple, d.pointsJoueur AS pointsDouble, partial s.{id, chjoueurId}
            FROM sws\Bundle\BackBundle\Entity\ChJoueurPtsSimple s, sws\Bundle\BackBundle\Entity\ChJoueurPtsDouble d
            WHERE
                s.championnat_id = d.championnat_id
                AND s.chjoueurId = d.chjoueurId
                AND s.championnat_id = " .$idChampionnat->getId()."
                ORDER BY points DESC

            ");


        $query2 = $this->_em->createQuery($query);
        $query2->setMaxResults($limit);
        $results = $query2->getResult();

        return $results;
    }

    public function getTopJoueurDivision($chDivisionId)
    {

        $query = ("

            SELECT s.pointsJoueur + d.pointsJoueur AS points, s.pointsJoueur AS pointsSimple, d.pointsJoueur AS pointsDouble, partial s.{id, chjoueurId}
            FROM sws\Bundle\BackBundle\Entity\ChJoueurPtsSimple s, sws\Bundle\BackBundle\Entity\ChJoueurPtsDouble d
            WHERE
                s.championnat_id = d.championnat_id
                AND s.chjoueurId = d.chjoueurId
                AND s.chdivision_id = d.chdivision_id
                AND s.chdivision_id = " .$chDivisionId->getId()."
                GROUP BY s.chjoueurId 
                ORDER BY points DESC

            ");

        $query2 = $this->_em->createQuery($query);
        //$query2->setMaxResults($limit);
        $results = $query2->getResult();

        return $results;
    }

    public function getTopJoueurCorpo($chCorporationId)
    {

        $query = ("

            SELECT sum(s.pointsJoueur + d.pointsJoueur) AS points, sum(s.pointsJoueur) AS pointsSimple, sum(d.pointsJoueur) AS pointsDouble, partial s.{id, chjoueurId}
            FROM sws\Bundle\BackBundle\Entity\ChJoueurPtsSimple s, sws\Bundle\BackBundle\Entity\ChJoueurPtsDouble d
            WHERE
                s.championnat_id = d.championnat_id
                AND s.chjoueurId = d.chjoueurId
                AND s.chplanning_id = d.chplanning_id
                AND s.chdivision_id = d.chdivision_id
                AND s.chcorporation_id = " .$chCorporationId. "
                GROUP BY s.chjoueurId
                ORDER BY points DESC

            ");

        $query2 = $this->_em->createQuery($query);
        $results = $query2->getResult();

        return $results;
    }

    public function getPointsJoueur($idChJoueur)
    {

        $query = ("

            SELECT s.pointsJoueur + d.pointsJoueur AS points, s.pointsJoueur AS pointsSimple, d.pointsJoueur AS pointsDouble, partial s.{id, chjoueurId},
            (SELECT max(b.dateRencontre) FROM sws\Bundle\BackBundle\Entity\ChJoueurPtsSimple a, sws\Bundle\BackBundle\Entity\ChPLanning b  WHERE a.chplanning_id = b.id and a.chjoueurId = ".$idChJoueur->getId().") AS maxDateRencontre,
            (SELECT count(1) FROM sws\Bundle\BackBundle\Entity\ChJoueurPtsSimple e WHERE e.chjoueurId = ".$idChJoueur->getId().") AS nbRencontre
            FROM sws\Bundle\BackBundle\Entity\ChJoueurPtsSimple s, sws\Bundle\BackBundle\Entity\ChJoueurPtsDouble d
            WHERE
                s.chjoueurId = ".$idChJoueur->getId()."
                and s.chjoueurId = d.chjoueurId
            ");

        $query2 = $this->_em->createQuery($query);
        $results = $query2->getResult();

        return $results;
    }
}
