<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * Championnat
 *
 * @ORM\Table(name="Championnat")
 * @ORM\Entity(repositoryClass="sws\Bundle\BackBundle\Entity\ChampionnatRepository")
 */
class Championnat
{
    public function __construct()
    {
        $this->status            = true;
    }

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @Assert\NotBlank()
     * @var string
     *
     * @ORM\Column(name="nom", type="string", length=255)
     */
    private $nom;

    /**
     * @Assert\DateTime()
     * @Assert\NotBlank()
     * @var \DateTime
     *
     * @ORM\Column(name="dateDebut", type="date")
     */
    private $dateDebut;

    /**
     * @Assert\DateTime()
     * @Assert\NotBlank()
     * @var \DateTime
     *
     * @ORM\Column(name="dateFin", type="date")
     */
    private $dateFin;

    /**
     * @var boolean
     *
     * @ORM\Column(name="status", type="boolean")
     */
    private $status;

    /**
     * @var boolean
     *
     * @ORM\Column(name="setTdb", type="boolean")
     */
    private $setTdb;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="create")
     * @ORM\Column(name="createdAt", type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="update")
     * @ORM\Column(name="updatedAt", type="datetime")
     */
    private $updatedAt;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="championnats")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     */
    protected $user;

    /**
     * @ORM\OneToMany(targetEntity="ChParametres", mappedBy="championnat_id")
     *
     */
    private $chparametres_id;

    /**
     * @ORM\OneToMany(targetEntity="ChSalle", mappedBy="championnat_id")
     *
     */
    private $chSalles;

    /**
     * @ORM\OneToMany(targetEntity="ChLocation", mappedBy="championnat_id")
     *
     */
    private $chlocations;

    /**
     * @Gedmo\Slug(fields={"nom"})
     * @ORM\Column(length=128, unique=true)
     */

    private $slug;


    /**
     * @return mixed
     */
    public function getSlug()
    {
        return $this->slug;
    }


    /**
     * @return mixed
     */
    public function getChparametresId()
    {
        return $this->chparametres_id;
    }

    /**
     * @param mixed $chparametres_id
     */
    public function setChparametresId($chparametres_id)
    {
        $this->chparametres_id = $chparametres_id;
    }


    /**
     * @return mixed
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @param mixed $user
     */
    public function setUser($user)
    {
        $this->user = $user;
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nom
     *
     * @param string $nom
     * @return Championnat
     */
    public function setNom($nom)
    {
        $this->nom = $nom;

        return $this;
    }

    /**
     * Get nom
     *
     * @return string 
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * Set dateDebut
     *
     * @param \DateTime $dateDebut
     * @return Championnat
     */
    public function setDateDebut($dateDebut)
    {
        $this->dateDebut = $dateDebut;

        return $this;
    }

    /**
     * Get dateDebut
     *
     * @return \DateTime 
     */
    public function getDateDebut()
    {
        return $this->dateDebut;
    }

    /**
     * Set dateFin
     *
     * @param \DateTime $dateFin
     * @return Championnat
     */
    public function setDateFin($dateFin)
    {
        $this->dateFin = $dateFin;

        return $this;
    }

    /**
     * Get dateFin
     *
     * @return \DateTime 
     */
    public function getDateFin()
    {
        return $this->dateFin;
    }

    /**
     * Set status
     *
     * @param boolean $status
     * @return Championnat
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return boolean 
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set setTdb
     *
     * @param boolean $setTdb
     * @return Championnat
     */
    public function setSetTdb($setTdb)
    {
        $this->setTdb = $setTdb;

        return $this;
    }

    /**
     * Get setTdb
     *
     * @return boolean 
     */
    public function getSetTdb()
    {
        return $this->setTdb;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime 
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Get updatedAt
     *
     * @return \DateTime 
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * Add championnat_id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChParametres $championnatId
     * @return Championnat
     */
    public function addChampionnatId(\sws\Bundle\BackBundle\Entity\ChParametres $championnatId)
    {
        $this->championnat_id[] = $championnatId;

        return $this;
    }

    /**
     * Remove championnat_id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChParametres $championnatId
     */
    public function removeChampionnatId(\sws\Bundle\BackBundle\Entity\ChParametres $championnatId)
    {
        $this->championnat_id->removeElement($championnatId);
    }

    /**
     * Get championnat_id
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getChampionnatId()
    {
        return $this->championnat_id;
    }

    /**
     * Add chSalles
     *
     * @param \sws\Bundle\BackBundle\Entity\ChSalle $chSalles
     * @return Championnat
     */
    public function addChSalle(\sws\Bundle\BackBundle\Entity\ChSalle $chSalles)
    {
        $this->chSalles[] = $chSalles;

        return $this;
    }

    /**
     * Remove chSalles
     *
     * @param \sws\Bundle\BackBundle\Entity\ChSalle $chSalles
     */
    public function removeChSalle(\sws\Bundle\BackBundle\Entity\ChSalle $chSalles)
    {
        $this->chSalles->removeElement($chSalles);
    }

    /**
     * Get chSalles
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getChSalles()
    {
        return $this->chSalles;
    }

    /**
     * Add chlocations
     *
     * @param \sws\Bundle\BackBundle\Entity\ChLocation $chlocations
     * @return Championnat
     */
    public function addChlocation(\sws\Bundle\BackBundle\Entity\ChLocation $chlocations)
    {
        $this->chlocations[] = $chlocations;

        return $this;
    }

    /**
     * Remove chlocations
     *
     * @param \sws\Bundle\BackBundle\Entity\ChLocation $chlocations
     */
    public function removeChlocation(\sws\Bundle\BackBundle\Entity\ChLocation $chlocations)
    {
        $this->chlocations->removeElement($chlocations);
    }

    /**
     * Get chlocations
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getChlocations()
    {
        return $this->chlocations;
    }

    /**
     * Add chparametres_id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChParametres $chparametresId
     * @return Championnat
     */
    public function addChparametresId(\sws\Bundle\BackBundle\Entity\ChParametres $chparametresId)
    {
        $this->chparametres_id[] = $chparametresId;

        return $this;
    }

    /**
     * Remove chparametres_id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChParametres $chparametresId
     */
    public function removeChparametresId(\sws\Bundle\BackBundle\Entity\ChParametres $chparametresId)
    {
        $this->chparametres_id->removeElement($chparametresId);
    }
}
